/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.faraday_cage.Vocabulary;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.aksw.faraday_cage.parameter.conversions.DictListParameterConversion;
import org.aksw.faraday_cage.parameter.conversions.ParameterConversion;
import org.aksw.faraday_cage.parameter.conversions.StringParameterConversion;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.SimpleSelector;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class FilterEnrichmentOperator
extends AbstractParametrizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(FilterEnrichmentOperator.class);
    private static final Property SUBJECT = Vocabulary.property((String)"subject");
    private static final Property PREDICATE = Vocabulary.property((String)"predicate");
    private static final Property OBJECT = Vocabulary.property((String)"object");
    private static final Parameter SELECTORS = new ParameterImpl("selectors", (ParameterConversion)new DictListParameterConversion(new Property[]{SUBJECT, PREDICATE, OBJECT}), false);
    private static final Parameter SPARQL_CONSTRUCT_QUERY = new ParameterImpl("sparqlConstructQuery", (ParameterConversion)StringParameterConversion.getInstance(), false);
    private List<Map<Property, RDFNode>> selectors = new ArrayList<Map<Property, RDFNode>>();
    private String sparqlQuery;

    protected List<Model> safeApply(List<Model> models) {
        return List.of(this.filterModel(models.get(0)));
    }

    private Model filterModel(Model model) {
        Model resultModel = ModelFactory.createDefaultModel();
        if (this.sparqlQuery != null) {
            resultModel = QueryExecutionFactory.create((String)this.sparqlQuery, (Model)model).execConstruct();
        } else {
            for (Map<Property, RDFNode> selectorMap : this.selectors) {
                RDFNode s = selectorMap.get(SUBJECT);
                RDFNode p = selectorMap.get(PREDICATE);
                SimpleSelector selector = new SimpleSelector(s == null ? null : s.asResource(), p == null ? null : (Property)p.as(Property.class), selectorMap.get(OBJECT));
                resultModel.add(model.listStatements((Selector)selector));
            }
        }
        return resultModel;
    }

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{SELECTORS, SPARQL_CONSTRUCT_QUERY});
    }

    public void validateAndAccept(@NotNull ParameterMap params) {
        this.selectors = (List)params.getValue(SELECTORS, new ArrayList());
        this.sparqlQuery = (String)params.getValue(SPARQL_CONSTRUCT_QUERY, null);
        if (this.selectors.size() == 0) {
            this.selectors.add(new HashMap());
        }
    }

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        ParameterMap result = this.createParameterMap();
        Model intersection = source.intersection(target);
        if (intersection.isEmpty()) {
            return result;
        }
        ArrayList selectors = new ArrayList();
        intersection.listStatements().forEachRemaining(stmt -> {
            HashMap<Property, Property> selectorMap = new HashMap<Property, Property>();
            selectorMap.put(PREDICATE, stmt.getPredicate());
            selectors.add(selectorMap);
        });
        result.setValue(SELECTORS, selectors);
        return result;
    }
}

