/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.github.therapi.runtimejavadoc.RetainJavadoc;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.faraday_cage.Vocabulary;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.aksw.faraday_cage.parameter.conversions.DictListParameterConversion;
import org.aksw.faraday_cage.parameter.conversions.ParameterConversion;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.OWL;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
@RetainJavadoc
public class DereferencingEnrichmentOperator
extends AbstractParametrizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(DereferencingEnrichmentOperator.class);
    private static final Property LOOKUP_PROPERTY = Vocabulary.property((String)"lookUpProperty");
    private static final Property LOOKUP_PREFIX = Vocabulary.property((String)"lookUpPrefix");
    private static final Property DEREFERENCING_PROPERTY = Vocabulary.property((String)"dereferencingProperty");
    private static final Property IMPORT_PROPERTY = Vocabulary.property((String)"importProperty");
    private static final Parameter OPERATIONS = new ParameterImpl("operations", (ParameterConversion)new DictListParameterConversion(new Property[]{LOOKUP_PREFIX, LOOKUP_PROPERTY, DEREFERENCING_PROPERTY, IMPORT_PROPERTY}), true);
    private static final String DEFAULT_LOOKUP_PREFIX = "http://dbpedia.org/resource";
    private static final Set<Property> ignoredProperties = new HashSet<Property>(Arrays.asList(OWL.sameAs));
    private HashMap<OperationGroup, Set<Property[]>> operations;
    private Model model;

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        ParameterMap parameters = this.createParameterMap();
        Set<Property> propertyDifference = this.getPropertyDifference(source, target);
        ArrayList autoOperations = new ArrayList();
        for (Property property : propertyDifference) {
            HashMap<Property, Property> autoOperation = new HashMap<Property, Property>();
            autoOperation.put(DEREFERENCING_PROPERTY, property);
            autoOperation.put(IMPORT_PROPERTY, property);
            autoOperations.add(autoOperation);
        }
        parameters.setValue(OPERATIONS, autoOperations);
        return parameters;
    }

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{OPERATIONS});
    }

    public void validateAndAccept(@NotNull ParameterMap params) {
        List origOps = (List)params.getValue(OPERATIONS);
        this.operations = new HashMap();
        for (Map op : origOps) {
            String lookUpPrefix = op.get(LOOKUP_PREFIX) == null ? DEFAULT_LOOKUP_PREFIX : ((RDFNode)op.get(LOOKUP_PREFIX)).toString();
            Property lookUpProperty = op.get(LOOKUP_PROPERTY) == null ? null : (Property)((RDFNode)op.get(LOOKUP_PROPERTY)).as(Property.class);
            Property dereferencingProperty = op.get(DEREFERENCING_PROPERTY) == null ? null : (Property)((RDFNode)op.get(DEREFERENCING_PROPERTY)).as(Property.class);
            Property importProperty = op.get(IMPORT_PROPERTY) == null ? dereferencingProperty : (Property)((RDFNode)op.get(IMPORT_PROPERTY)).as(Property.class);
            OperationGroup opGroup = new OperationGroup(lookUpProperty, lookUpPrefix);
            if (!this.operations.containsKey(opGroup)) {
                this.operations.put(opGroup, new HashSet());
            }
            this.operations.get(opGroup).add(new Property[]{dereferencingProperty, importProperty});
        }
    }

    protected List<Model> safeApply(List<Model> models) {
        this.model = ModelFactory.createDefaultModel().add(models.get(0));
        this.operations.forEach(this::runOperation);
        return Lists.newArrayList((Object[])new Model[]{this.model});
    }

    private void runOperation(OperationGroup opGroup, Set<Property[]> ops) {
        HashMap dereffedPerResource = new HashMap();
        List<Statement> candidateNodes = this.getCandidateNodes(opGroup.lookupPrefix, opGroup.lookupProperty);
        candidateNodes.stream().map(Statement::getResource).distinct().forEach(o -> dereffedPerResource.put(o, this.getEnrichmentPairsFor((Resource)o, ops)));
        for (Statement stmt : candidateNodes) {
            for (Pair pair : (List)dereffedPerResource.get(stmt.getResource())) {
                stmt.getSubject().addProperty((Property)pair.getLeft(), (RDFNode)pair.getRight());
            }
        }
    }

    private List<Pair<Property, RDFNode>> getEnrichmentPairsFor(Resource o, Set<Property[]> ops) {
        ArrayList<Pair<Property, RDFNode>> result = new ArrayList<Pair<Property, RDFNode>>();
        Model resourceModel = this.queryResourceModel(o);
        for (Property[] op : ops) {
            resourceModel.listStatements(o, op[0], (RDFNode)null).mapWith(Statement::getObject).forEachRemaining(x -> result.add((Pair<Property, RDFNode>)new ImmutablePair((Object)op[1], x)));
        }
        return result;
    }

    private Model queryResourceModel(Resource o) {
        URL url;
        Model result = ModelFactory.createDefaultModel();
        URLConnection conn = null;
        try {
            url = new URL(o.getURI());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return result;
        }
        try {
            conn = url.openConnection();
            conn.setRequestProperty("Accept", "application/rdf+xml");
            conn.setRequestProperty("Accept-Language", "en");
            return ModelFactory.createDefaultModel().read(conn.getInputStream(), null);
        }
        catch (ConnectException e) {
            if (e.getMessage().contains("refused")) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private List<Statement> getCandidateNodes(String lookupPrefix, Property lookUpProperty) {
        return this.model.listStatements().filterKeep(statement -> statement.getObject().isURIResource() && statement.getObject().asResource().getURI().startsWith(lookupPrefix) && (lookUpProperty == null || statement.getPredicate().equals(lookUpProperty))).toList();
    }

    private Set<Property> getPropertyDifference(Model source, Model target) {
        Function<Model, Set> getProperties = m -> m.listStatements().mapWith(Statement::getPredicate).toSet();
        return Sets.difference((Set)getProperties.apply(source), (Set)getProperties.apply(target)).stream().filter(p -> !ignoredProperties.contains(p)).collect(Collectors.toSet());
    }

    private static class OperationGroup {
        private final Property lookupProperty;
        private final String lookupPrefix;

        private OperationGroup(Property lookupProperty, String lookupPrefix) {
            this.lookupProperty = lookupProperty;
            this.lookupPrefix = lookupPrefix;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OperationGroup)) {
                return false;
            }
            OperationGroup other = (OperationGroup)obj;
            return (this.lookupPrefix == null ? other.lookupPrefix == null : this.lookupPrefix.equals(other.lookupPrefix)) && (this.lookupProperty == null ? other.lookupProperty == null : this.lookupProperty.equals(other.lookupProperty));
        }

        public int hashCode() {
            return (this.lookupPrefix == null ? -1 : this.lookupPrefix.hashCode()) + 13 * (this.lookupProperty == null ? -1 : this.lookupProperty.hashCode());
        }
    }
}

