/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.deer.vocabulary.SCMSANN;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.aksw.fox.binding.FoxApi;
import org.aksw.fox.binding.FoxParameter;
import org.aksw.fox.binding.IFoxApi;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class NEREnrichmentOperator
extends AbstractParametrizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(NEREnrichmentOperator.class);
    private static final Parameter LITERAL_PROPERTY = new ParameterImpl("literalProperty");
    private static final Parameter IMPORT_PROPERTY = new ParameterImpl("importProperty");
    private static final Parameter FOX_URL = new ParameterImpl("foxUrl");
    private static final Parameter NE_TYPE = new ParameterImpl("neType");
    private static final Parameter ASK_ENDPOINT = new ParameterImpl("askEndpoint");
    private static final Parameter DBPEDIA_ENDPOINT_URL = new ParameterImpl("dbpediaEndpointUrl");
    private static final String DEFAULT_FOX_URL = "http://localhost:4444/fox";
    private static final String DEFAULT_IMPORT_PROPERTY = "http://geoknow.org/ontology/relatedTo";
    private Property literalProperty;
    private Property importProperty;
    private URL foxUri;
    private String dbpediaEndpointUri;
    private boolean askEndPoint;
    private NET neType;

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{LITERAL_PROPERTY, IMPORT_PROPERTY, FOX_URL, NE_TYPE, ASK_ENDPOINT, DBPEDIA_ENDPOINT_URL});
    }

    public void validateAndAccept(@NotNull ParameterMap params) {
        this.literalProperty = params.getValue(LITERAL_PROPERTY) == null ? null : ResourceFactory.createProperty((String)((String)params.getValue(LITERAL_PROPERTY)));
        this.importProperty = ResourceFactory.createProperty((String)((String)params.getValue(IMPORT_PROPERTY, (Object)DEFAULT_IMPORT_PROPERTY)));
        try {
            this.foxUri = new URL((URL)params.getValue(FOX_URL), DEFAULT_FOX_URL);
            this.dbpediaEndpointUri = (String)params.getValue(DBPEDIA_ENDPOINT_URL, (Object)"http://dbpedia.org/util");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unresolvable bad URL encountered.", e);
        }
        this.askEndPoint = Boolean.valueOf((String)params.getValue(ASK_ENDPOINT, (Object)"false"));
        this.neType = NET.valueOf((String)params.getValue(NE_TYPE, (Object)NET.ALL.toString()));
    }

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        return ParameterMap.EMPTY_INSTANCE;
    }

    protected List<Model> safeApply(List<Model> models) {
        Model model = models.get(0);
        Model resultModel = ModelFactory.createDefaultModel();
        resultModel.add(model);
        if (this.literalProperty == null) {
            this.literalProperty = LiteralPropertyRanker.getTopRankedProperty(model);
        }
        model.listStatements(null, this.literalProperty, (RDFNode)null).filterKeep(statement -> statement.getObject().isLiteral()).forEachRemaining(statement -> {
            Resource subject = statement.getSubject();
            Model namedEntityModel = this.runFOX(statement.getObject().toString());
            if (!namedEntityModel.isEmpty()) {
                switch (this.neType) {
                    case ALL: {
                        resultModel.add(this.getNE(namedEntityModel, subject));
                        break;
                    }
                    case LOCATION: {
                        resultModel.add(this.getNE(namedEntityModel, subject, (Resource)SCMSANN.LOCATION));
                        break;
                    }
                    case PERSON: {
                        resultModel.add(this.getNE(namedEntityModel, subject, (Resource)SCMSANN.PERSON));
                        break;
                    }
                    case ORGANIZATION: {
                        resultModel.add(this.getNE(namedEntityModel, subject, (Resource)SCMSANN.ORGANIZATION));
                    }
                }
            }
        });
        return Lists.newArrayList((Object[])new Model[]{resultModel});
    }

    private List<Statement> getNE(Model namedEntityModel, Resource subject, Resource type) {
        String sparqlQueryString = "CONSTRUCT {?s ?p ?o}  WHERE {?s a <" + type + ">. ?s ?p ?o} ";
        Model locationsModel = QueryExecutionFactory.create((String)sparqlQueryString, (Model)namedEntityModel).execConstruct();
        return this.getNE(locationsModel, subject);
    }

    private List<Statement> getNE(Model namedEntityModel, Resource subject) {
        return namedEntityModel.listObjectsOfProperty(SCMSANN.MEANS).filterKeep(RDFNode::isResource).mapWith(RDFNode::asResource).filterDrop(r -> this.askEndPoint && !this.isPlace((RDFNode)r)).mapWith(r -> ResourceFactory.createStatement((Resource)subject, (Property)this.importProperty, (RDFNode)r)).toList();
    }

    private boolean isPlace(RDFNode uri) {
        if (uri.toString().contains("http://ns.aksw.org/scms/")) {
            return false;
        }
        String queryString = "ask {<" + uri.toString() + "> a <http://dbpedia.org/ontology/Place>}";
        logger.info("Asking DBpedia for: " + queryString);
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.dbpediaEndpointUri, (Query)query);
        boolean result = qexec.execAsk();
        logger.info("Answer: " + result);
        return result;
    }

    private Model runFOX(String input) {
        Model namedEntityModel = ModelFactory.createDefaultModel();
        IFoxApi fox = new FoxApi().setApiURL(this.foxUri).setTask(FoxParameter.TASK.NER).setOutputFormat(FoxParameter.OUTPUT.TURTLE).setLang(FoxParameter.LANG.EN).setInput(input).send();
        namedEntityModel.read((Reader)new StringReader(fox.responseAsFile().trim()), null, "TTL");
        return namedEntityModel;
    }

    private static class LiteralPropertyRanker {
        private LiteralPropertyRanker() {
        }

        static SortedMap<Double, Property> rank(Model model) {
            TreeMap<Double, Property> propertyRanks = new TreeMap<Double, Property>(Collections.reverseOrder());
            model.listStatements().mapWith(Statement::getPredicate).forEachRemaining(property -> {
                AtomicLong totalLitSize = new AtomicLong(1L);
                AtomicLong totalLitCount = new AtomicLong(0L);
                model.listObjectsOfProperty(property).filterKeep(RDFNode::isLiteral).mapWith(RDFNode::asLiteral).forEachRemaining(l -> {
                    totalLitCount.getAndIncrement();
                    totalLitSize.addAndGet(l.toString().length());
                });
                double avgLitSize = (double)totalLitSize.get() / (double)totalLitCount.get();
                propertyRanks.put(avgLitSize, (Property)property);
            });
            return propertyRanks;
        }

        static Property getTopRankedProperty(Model model) {
            SortedMap<Double, Property> ranks = LiteralPropertyRanker.rank(model);
            return (Property)ranks.get(ranks.firstKey());
        }
    }

    private static enum NET {
        ORGANIZATION,
        LOCATION,
        PERSON,
        ALL;

    }
}

