/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.io;

import java.util.List;
import org.aksw.deer.io.AbstractModelIO;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.Execution;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class DefaultModelReader
extends AbstractModelIO {
    private static final Logger logger = LoggerFactory.getLogger(DefaultModelReader.class);
    private static final Parameter FROM_URI = new ParameterImpl("fromUri", false);
    private static final Parameter FROM_GRAPH = new ParameterImpl("fromGraph", false);
    private static final Parameter USE_TRIPLE_PATTERN = new ParameterImpl("useTriplePattern", false);
    private static final Parameter USE_ENDPOINT = new ParameterImpl("useEndpoint", false);
    private String fromUri;
    private String useEndpoint;
    private String fromGraph;
    private String triplePattern;

    protected void validateAndAccept(@NotNull ParameterMap parameterMap) {
        this.fromUri = (String)parameterMap.getValue(FROM_URI);
        this.fromGraph = (String)parameterMap.getValue(FROM_GRAPH);
        this.triplePattern = (String)parameterMap.getValue(USE_TRIPLE_PATTERN, (Object)"?s ?p ?o");
        this.useEndpoint = (String)parameterMap.getValue(USE_ENDPOINT);
    }

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{FROM_URI, FROM_GRAPH, USE_ENDPOINT});
    }

    protected List<Model> safeApply(List<Model> data) {
        return (List)Execution.toMultiExecution(m -> this.useEndpoint != null ? this.readModelFromEndPoint() : this.readModel(this.fromUri)).apply(data);
    }

    private Model readModel(String locator) {
        locator = this.injectWorkingDirectory(locator);
        try {
            Model model = ModelFactory.createDefaultModel();
            long startTime = System.currentTimeMillis();
            model.read(locator);
            logger.info("Loading {} is done in {}ms.", (Object)locator, (Object)(System.currentTimeMillis() - startTime));
            return model;
        }
        catch (HttpException e) {
            throw new RuntimeException("Encountered HTTPException trying to load model from " + locator, e);
        }
    }

    private Model readModelFromEndPoint() {
        Model result;
        long startTime = System.currentTimeMillis();
        logger.info("Reading dataset from " + this.useEndpoint);
        if (this.fromGraph != null) {
            String sparqlQueryString = "CONSTRUCT { ?s ?p ?o } WHERE { GRAPH <" + this.fromGraph + "> { " + this.triplePattern + " } . }";
            QueryExecution qExec = QueryExecutionFactory.sparqlService((String)this.useEndpoint, (String)sparqlQueryString);
            result = qExec.execConstruct();
            qExec.close();
        } else if (this.fromUri != null) {
            String sparqlQueryString = "DESCRIBE <" + this.fromUri + ">";
            QueryEngineHTTP qExec = new QueryEngineHTTP(this.useEndpoint, sparqlQueryString);
            qExec.setModelContentType("application/ld+json");
            result = qExec.execDescribe();
            qExec.close();
        } else {
            throw new RuntimeException("Neither " + FROM_URI.toString() + " nor " + DEER.fromGraph + " defined to read dataset from " + this.useEndpoint + ", exit with error.");
        }
        logger.info("Dataset reading is done in " + (System.currentTimeMillis() - startTime) + "ms, " + result.size() + " triples found.");
        return result;
    }
}

