/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.io;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import org.aksw.deer.ParametrizedDeerPlugin;
import org.aksw.faraday_cage.Vocabulary;
import org.aksw.faraday_cage.nodes.AbstractParametrizedNode;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModelIO
extends AbstractParametrizedNode.WithImplicitCloning<Model>
implements ParametrizedDeerPlugin {
    private static Supplier<String> workingDirectorySupplier = () -> "";

    public static void takeWorkingDirectoryFrom(Supplier<String> supplier) {
        if (supplier != null) {
            workingDirectorySupplier = supplier;
        }
    }

    protected final String injectWorkingDirectory(String locator) {
        boolean isFile = false;
        try {
            new URL(locator);
        }
        catch (MalformedURLException ignored) {
            isFile = true;
        }
        if (isFile) {
            Path currentDir = Paths.get(".", new String[0]);
            Path filePath = Paths.get(locator, new String[0]);
            if (filePath.isAbsolute()) {
                filePath = filePath.getFileName();
            }
            if (workingDirectorySupplier != null) {
                locator = currentDir.resolve(workingDirectorySupplier.get()).resolve(filePath).normalize().toString();
            }
        }
        return locator;
    }

    protected Model deepCopy(Model data) {
        return ModelFactory.createDefaultModel().add(data);
    }

    @NotNull
    public Resource getType() {
        return Vocabulary.resource((String)this.getClass().getSimpleName());
    }
}

