/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.aksw.faraday_cage.parameter.conversions.ParameterConversion;
import org.aksw.faraday_cage.parameter.conversions.StringParameterConversion;
import org.aksw.limes.core.controller.Controller;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.reader.xml.XMLConfigurationReader;
import org.aksw.limes.core.io.mapping.AMapping;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class LinkingEnrichmentOperator
extends AbstractParametrizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(LinkingEnrichmentOperator.class);
    private static final Parameter SPEC_FILE = new ParameterImpl("specFile");
    private static final Parameter LINKS_PART = new ParameterImpl("linksPart", (ParameterConversion)StringParameterConversion.getInstance(), true);
    private String specFile;
    private DATASET_PART linksPart;

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{SPEC_FILE, LINKS_PART});
    }

    public void validateAndAccept(@NotNull ParameterMap params) {
        this.linksPart = DATASET_PART.valueOf(((String)params.getValue(LINKS_PART, (Object)"source")).toUpperCase());
    }

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        return ParameterMap.EMPTY_INSTANCE;
    }

    protected List<Model> safeApply(List<Model> models) {
        Model model = this.setPrefixes(models.get(0));
        Configuration cfg = new XMLConfigurationReader(this.specFile).read();
        this.addLinksToModel(model, cfg, this.linksPart);
        return Lists.newArrayList((Object[])new Model[]{model});
    }

    private Model setPrefixes(Model model) {
        String gn = "http://www.geonames.org/ontology#";
        String owl = "http://www.w3.org/2002/07/owl#";
        model.setNsPrefix("gn", gn);
        model.setNsPrefix("owl", owl);
        return model;
    }

    private void addLinksToModel(Model model, Configuration cfg, DATASET_PART linksPart) {
        AMapping mapping = Controller.getMapping((Configuration)cfg).getAcceptanceMapping();
        Property predicate = model.createProperty(cfg.getAcceptanceRelation());
        for (String s : mapping.getMap().keySet()) {
            Resource subject = model.createResource(s);
            for (String t : ((HashMap)mapping.getMap().get(s)).keySet()) {
                Resource object = model.createResource(t);
                if (linksPart == DATASET_PART.SOURCE) {
                    model.add(subject, predicate, (RDFNode)object);
                    continue;
                }
                model.add(object, predicate, (RDFNode)subject);
            }
        }
    }

    private static enum DATASET_PART {
        SOURCE,
        TARGET;

    }
}

