/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.aksw.deer.ParametrizedDeerPlugin;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class AuthorityConformationEnrichmentOperator
extends AbstractParametrizedEnrichmentOperator
implements ParametrizedDeerPlugin {
    private static final Logger logger = LoggerFactory.getLogger(AuthorityConformationEnrichmentOperator.class);
    private static final Parameter SOURCE_SUBJECT_AUTHORITY = new ParameterImpl("sourceSubjectAuthority");
    private static final Parameter TARGET_SUBJECT_AUTHORITY = new ParameterImpl("targetSubjectAuthority");
    private String sourceSubjectAuthority;
    private String targetSubjectAuthority;

    protected List<Model> safeApply(List<Model> models) {
        Model input = models.get(0);
        Model output = ModelFactory.createDefaultModel();
        input.listStatements().forEachRemaining(stmt -> {
            Resource s = stmt.getSubject();
            if (!Objects.equals(this.sourceSubjectAuthority, "") && s.getURI().startsWith(this.sourceSubjectAuthority)) {
                String conformedUri = s.getURI().replaceFirst(this.sourceSubjectAuthority, this.targetSubjectAuthority);
                s = ResourceFactory.createResource((String)conformedUri);
            }
            output.add(s, stmt.getPredicate(), stmt.getObject());
        });
        return Lists.newArrayList((Object[])new Model[]{output});
    }

    private String getMostRedundantUri(Model m) {
        HashMultiset subjectsMultiset = HashMultiset.create();
        ResIterator listSubjects = m.listSubjects();
        while (listSubjects.hasNext()) {
            String authority = ((Resource)listSubjects.next()).toString();
            authority = authority.contains("#") ? authority.substring(0, authority.lastIndexOf("#")) : authority.substring(0, authority.lastIndexOf("/"));
            subjectsMultiset.add((Object)ResourceFactory.createResource((String)authority));
        }
        String result = "";
        int max = 0;
        for (Resource r : subjectsMultiset) {
            int i = subjectsMultiset.count((Object)r);
            if (i <= max) continue;
            max = i;
            result = r.getURI();
        }
        return result;
    }

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        String t;
        ParameterMap parameters = this.createParameterMap();
        String s = this.getMostRedundantUri(source);
        if (!Objects.equals(s, t = this.getMostRedundantUri(target))) {
            parameters.setValue(SOURCE_SUBJECT_AUTHORITY, (Object)s);
            parameters.setValue(TARGET_SUBJECT_AUTHORITY, (Object)s);
        }
        return parameters;
    }

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{SOURCE_SUBJECT_AUTHORITY, TARGET_SUBJECT_AUTHORITY});
    }

    public void validateAndAccept(@NotNull ParameterMap params) {
        this.sourceSubjectAuthority = (String)params.getValue(SOURCE_SUBJECT_AUTHORITY);
        this.targetSubjectAuthority = (String)params.getValue(TARGET_SUBJECT_AUTHORITY);
    }
}

