/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.internal.JavadocParser;
import java.util.ArrayList;

public final class DereferencingEnrichmentOperator__Javadoc {
    private DereferencingEnrichmentOperator__Javadoc() {
    }

    public static String getString() {
        return "An EnrichmentOperator for dereferencing.\n <p>\n Dereferencing is a method of expanding knowledge of resources that belong to an\n external knowledge base.\n We define a dereferencing operation as the following sequence of operations:\n <ol>\n     <li>Query the local model for starting resources {@code ?x}\n         that belong to an external knowledge base</li>\n     <li>Query the external knowledge base for triples {@code (?x, d, ?y)},\n         where d is a defined property path in the external knowledge base.</li>\n     <li>Add all results to the local model in the form of {@code (?x, i, ?y)},\n         where i is the property name under which they should be imported.</li>\n </ol>\n <h2>Configuration</h2>\n\n <h3>{@code :operations}</h3>\n\n A {@link DictListParameterConversion DictList}.\n\n Each entry in the {@code DictList} corresponds to one dereferencing operation, allowing multiple\n dereferencing operations being carried out by a single {@code DereferencingEnrichmentOperator}.\n Each entry may contain the following properties:\n\n <blockquote>\n     <b>{@code :lookUpPrefix} [required]</b>\n     <i>range: string</i>\n     <br>\n     Determines the starting resources {@code ?x} as all objects of triples having\n     the value of {@code :lookUpProperty} as predicate.\n </blockquote>\n\n <blockquote>\n     <b>{@code :dereferencingProperty} [required]</b>\n     <i>range: resource</i>\n     <br>\n     Look up the values to be imported to the local model in the external knowledge base\n     using the property defined by the value of {@code :dereferencingProperty}.\n </blockquote>\n\n <blockquote>\n     <b>{@code :importProperty} [required]</b>\n     <i>range: resource</i>\n     <br>\n     Add looked up values to starting resources using the value of :importProperty.\n </blockquote>\n\n <blockquote>\n     <b>{@code :endpoint} </b>\n     <i>range: string</i>\n     <br>\n     URL of the SPARQL endpoint to use for this dereferencing operation.\n     If not given, this operator tries to infer the endpoint from the starting resources URIs.\n </blockquote>\n\n <h2>Example</h2>";
    }

    public static ClassJavadoc getJavadoc() {
        ArrayList<MethodJavadoc> methods = new ArrayList<MethodJavadoc>();
        methods.add(JavadocParser.parseMethodJavadoc((String)"selfConfig", (String)" Self configuration\n Find source/target URI as the most redundant URIs\n\n @param source source\n @param target target\n\n @return Map of (key, value) pairs of self configured parameters\n"));
        return JavadocParser.parseClassJavadoc((String)"org.aksw.deer.enrichments.DereferencingEnrichmentOperator", (String)" An EnrichmentOperator for dereferencing.\n <p>\n Dereferencing is a method of expanding knowledge of resources that belong to an\n external knowledge base.\n We define a dereferencing operation as the following sequence of operations:\n <ol>\n     <li>Query the local model for starting resources {@code ?x}\n         that belong to an external knowledge base</li>\n     <li>Query the external knowledge base for triples {@code (?x, d, ?y)},\n         where d is a defined property path in the external knowledge base.</li>\n     <li>Add all results to the local model in the form of {@code (?x, i, ?y)},\n         where i is the property name under which they should be imported.</li>\n </ol>\n <h2>Configuration</h2>\n\n <h3>{@code :operations}</h3>\n\n A {@link DictListParameterConversion DictList}.\n\n Each entry in the {@code DictList} corresponds to one dereferencing operation, allowing multiple\n dereferencing operations being carried out by a single {@code DereferencingEnrichmentOperator}.\n Each entry may contain the following properties:\n\n <blockquote>\n     <b>{@code :lookUpPrefix} [required]</b>\n     <i>range: string</i>\n     <br>\n     Determines the starting resources {@code ?x} as all objects of triples having\n     the value of {@code :lookUpProperty} as predicate.\n </blockquote>\n\n <blockquote>\n     <b>{@code :dereferencingProperty} [required]</b>\n     <i>range: resource</i>\n     <br>\n     Look up the values to be imported to the local model in the external knowledge base\n     using the property defined by the value of {@code :dereferencingProperty}.\n </blockquote>\n\n <blockquote>\n     <b>{@code :importProperty} [required]</b>\n     <i>range: resource</i>\n     <br>\n     Add looked up values to starting resources using the value of :importProperty.\n </blockquote>\n\n <blockquote>\n     <b>{@code :endpoint} </b>\n     <i>range: string</i>\n     <br>\n     URL of the SPARQL endpoint to use for this dereferencing operation.\n     If not given, this operator tries to infer the endpoint from the starting resources URIs.\n </blockquote>\n\n <h2>Example</h2>\n\n", methods);
    }
}

