/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.enrichments;

import com.github.therapi.runtimejavadoc.RetainJavadoc;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.deer.enrichments.AbstractParametrizedEnrichmentOperator;
import org.aksw.faraday_cage.Vocabulary;
import org.aksw.faraday_cage.parameter.Parameter;
import org.aksw.faraday_cage.parameter.ParameterImpl;
import org.aksw.faraday_cage.parameter.ParameterMap;
import org.aksw.faraday_cage.parameter.ParameterMapImpl;
import org.aksw.faraday_cage.parameter.conversions.DictListParameterConversion;
import org.aksw.faraday_cage.parameter.conversions.ParameterConversion;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.OWL;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
@RetainJavadoc
public class DereferencingEnrichmentOperator
extends AbstractParametrizedEnrichmentOperator {
    private static final Logger logger = LoggerFactory.getLogger(DereferencingEnrichmentOperator.class);
    private static final Property LOOKUP_PREFIX = Vocabulary.property((String)"lookUpPrefix");
    private static final Property DEREFERENCING_PROPERTY = Vocabulary.property((String)"dereferencingProperty");
    private static final Property IMPORT_PROPERTY = Vocabulary.property((String)"importProperty");
    private static final Parameter OPERATIONS = new ParameterImpl("operations", (ParameterConversion)new DictListParameterConversion(new Property[]{LOOKUP_PREFIX, DEREFERENCING_PROPERTY, IMPORT_PROPERTY}), true);
    private static final String DEFAULT_LOOKUP_PREFIX = "http://dbpedia.org/resource";
    private static final Set<Property> ignoredProperties = new HashSet<Property>(Arrays.asList(OWL.sameAs));
    private List<Map<Property, RDFNode>> operations;
    private Model model;

    @Override
    @NotNull
    public ParameterMap selfConfig(Model source, Model target) {
        ParameterMap parameters = this.createParameterMap();
        Set<Property> propertyDifference = this.getPropertyDifference(source, target);
        ArrayList autoOperations = new ArrayList();
        for (Property property : propertyDifference) {
            HashMap<Property, Property> autoOperation = new HashMap<Property, Property>();
            autoOperation.put(DEREFERENCING_PROPERTY, property);
            autoOperation.put(IMPORT_PROPERTY, property);
            autoOperations.add(autoOperation);
        }
        parameters.setValue(OPERATIONS, autoOperations);
        return parameters;
    }

    @NotNull
    public ParameterMap createParameterMap() {
        return new ParameterMapImpl(new Parameter[]{OPERATIONS});
    }

    public void validateAndAccept(@NotNull ParameterMap params) {
        this.operations = (List)params.getValue(OPERATIONS);
    }

    protected List<Model> safeApply(List<Model> models) {
        this.model = ModelFactory.createDefaultModel().add(models.get(0));
        this.operations.forEach(this::runOperation);
        return Lists.newArrayList((Object[])new Model[]{this.model});
    }

    private void runOperation(Map<Property, RDFNode> op) {
        Property importProperty;
        String lookUpPrefix = op.get(LOOKUP_PREFIX) == null ? DEFAULT_LOOKUP_PREFIX : op.get(LOOKUP_PREFIX).toString();
        Property dereferencingProperty = op.get(DEREFERENCING_PROPERTY) == null ? null : (Property)op.get(DEREFERENCING_PROPERTY).as(Property.class);
        Property property = importProperty = op.get(IMPORT_PROPERTY) == null ? dereferencingProperty : (Property)op.get(IMPORT_PROPERTY).as(Property.class);
        if (dereferencingProperty != null) {
            for (Resource s : this.getCandidateNodesByPrefix(lookUpPrefix)) {
                for (RDFNode o : this.getEnrichmentValuesFor(s, dereferencingProperty)) {
                    s.addProperty(importProperty, o);
                }
            }
        }
    }

    private List<Resource> getCandidateNodesByPrefix(String lookupPrefix) {
        return this.model.listStatements().mapWith(Statement::getObject).filterKeep(RDFNode::isURIResource).mapWith(RDFNode::asResource).filterKeep(o -> o.getURI().startsWith(lookupPrefix)).toList();
    }

    private List<RDFNode> getEnrichmentValuesFor(Resource resource, Property dereferencingProperty) {
        try {
            URLConnection conn = new URL(resource.getURI()).openConnection();
            conn.setRequestProperty("Accept", "application/rdf+xml");
            conn.setRequestProperty("Accept-Language", "en");
            return ModelFactory.createDefaultModel().read(conn.getInputStream(), null).listStatements(resource, dereferencingProperty, (RDFNode)null).mapWith(Statement::getObject).filterDrop(v -> v.isLiteral() && !Arrays.asList("en", "").contains(v.asLiteral().getLanguage().toLowerCase())).toList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private Set<Property> getPropertyDifference(Model source, Model target) {
        Function<Model, Set> getProperties = m -> m.listStatements().mapWith(Statement::getPredicate).toSet();
        return Sets.difference((Set)getProperties.apply(source), (Set)getProperties.apply(target)).stream().filter(p -> !ignoredProperties.contains(p)).collect(Collectors.toSet());
    }
}

