/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer;

import org.aksw.deer.DeerPlugin;
import org.aksw.deer.vocabulary.DEER;
import org.aksw.faraday_cage.CompletableFutureFactory;
import org.aksw.faraday_cage.DefaultExecutionGraphBuilder;
import org.aksw.faraday_cage.ExecutionGraph;
import org.aksw.faraday_cage.ExecutionGraphBuilder;
import org.aksw.faraday_cage.ExecutionGraphGenerator;
import org.aksw.faraday_cage.IdentifiableExecutionFactory;
import org.aksw.faraday_cage.PluginFactory;
import org.aksw.faraday_cage.Vocabulary;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.jena.rdf.model.Model;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deer {
    private static final Logger logger = LoggerFactory.getLogger(Deer.class);

    public void run(Model config, PluginManager pluginManager, CompletableFutureFactory futureFactory) {
        Vocabulary.setDefaultURI((String)DEER.getURI());
        StopWatch time = new StopWatch();
        logger.info("Building execution model...");
        time.start();
        PluginFactory deerFactory = new PluginFactory(DeerPlugin.class, pluginManager);
        DefaultExecutionGraphBuilder executionGraphBuilder = new DefaultExecutionGraphBuilder(futureFactory);
        ExecutionGraphGenerator executionGraphGenerator = new ExecutionGraphGenerator(config, (ExecutionGraphBuilder)executionGraphBuilder, (IdentifiableExecutionFactory)deerFactory);
        ExecutionGraph executionGraph = executionGraphGenerator.generate();
        time.split();
        logger.info("Execution model built after {}ms.", (Object)time.getSplitTime());
        logger.info("Starting execution of enrichment...");
        executionGraph.run();
        time.split();
        logger.info("Enrichment finished after {}ms", (Object)time.getSplitTime());
    }
}

