/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Part;
import org.aksw.deer.DeerController;
import org.aksw.deer.io.AbstractModelIO;
import org.aksw.deer.server.RequestHealthChecker;
import org.aksw.faraday_cage.engine.CompiledExecutionGraph;
import org.aksw.faraday_cage.engine.FaradayCageContext;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import spark.Filter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    public static final String STORAGE_DIR_PATH = ".server-storage/";
    public static final String LOG_DIR_PATH = ".server-storage/logs/";
    private static final Gson GSON = new GsonBuilder().create();
    private static Server instance = null;
    private static Model SHAPES_MODEL = DeerController.getShapes();
    private final ConcurrentMap<String, CompletableFuture<Void>> requests = new ConcurrentHashMap<String, CompletableFuture<Void>>();
    private final File uploadDir = new File(".server-storage/");
    private int port = -1;

    public static Server getInstance() {
        if (instance == null) {
            instance = new Server();
        }
        return instance;
    }

    public void run(int port) {
        if (this.port > 0) {
            throw new IllegalStateException("Server already running on port " + port + "!");
        }
        this.port = port;
        if (!this.uploadDir.exists()) {
            this.uploadDir.mkdir();
        }
        FaradayCageContext.addForkListener(runId -> MDC.put((String)"requestId", (String)runId));
        AbstractModelIO.takeWorkingDirectoryFrom(() -> STORAGE_DIR_PATH + FaradayCageContext.getRunId() + "/");
        Spark.staticFiles.expireTime(0L);
        Spark.staticFiles.location("/gui");
        Spark.threadPool((int)100, (int)1, (int)30000);
        Spark.port((int)port);
        Server.enableCORS("*", "GET, POST, OPTIONS", "");
        Spark.post((String)"/submit", this::handleSubmit);
        Spark.get((String)"/shapes", this::handleShapes);
        Spark.get((String)"/status/:id", this::handleStatus);
        Spark.get((String)"/logs/:id", this::handleLogs);
        Spark.get((String)"/results/:id", this::handleResults);
        Spark.get((String)"/result/:id/:file", this::handleResult);
        Spark.exception(Exception.class, (e, req, res) -> {
            logger.error("Error in processing request" + req.uri(), (Throwable)e);
            res.status(500);
            res.type("application/json");
            res.body(GSON.toJson((Object)new ErrorMessage(e)));
        });
        Spark.notFound((req, res) -> {
            res.redirect("/");
            return "";
        });
        Spark.init();
        Spark.awaitInitialization();
    }

    private Server() {
        new RequestHealthChecker(this.requests).start();
    }

    private Object handleSubmit(Request req, Response res) throws IOException, ServletException {
        String runId = FaradayCageContext.newRunId();
        File workingDir = new File(this.uploadDir.getAbsoluteFile(), runId);
        if (!workingDir.mkdirs()) {
            throw new IOException("Not able to create directory " + workingDir.getAbsolutePath());
        }
        req.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(workingDir.getAbsolutePath()));
        Path configFile = null;
        if (req.contentType().contains("multipart/form-data")) {
            for (Part part : req.raw().getParts()) {
                InputStream is = part.getInputStream();
                try {
                    Path partFileName = Paths.get(part.getSubmittedFileName(), new String[0]).getFileName();
                    Path destinationPath = workingDir.toPath().resolve(partFileName);
                    Files.copy(is, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                    if (part.getName().equals("config")) {
                        configFile = destinationPath;
                    }
                    logger.info("Uploaded file '{}' to '{}'", (Object)partFileName, (Object)destinationPath);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        } else {
            return GSON.toJson((Object)new ErrorMessage(1, "Only Requests of type \"multipart/form-data\" are allowed"));
        }
        if (Objects.isNull(configFile)) {
            return GSON.toJson((Object)new ErrorMessage(2, "No configuration was submitted"));
        }
        MDC.put((String)"requestId", (String)runId);
        CompiledExecutionGraph compiledExecutionGraph = DeerController.compileDeer(configFile.toString(), runId);
        compiledExecutionGraph.andThen(() -> DeerController.writeAnalytics(workingDir.toPath().resolve("deer-analytics.json")));
        this.requests.put(runId, (CompletableFuture<Void>)CompletableFuture.completedFuture(null).thenAcceptAsync($ -> {
            MDC.put((String)"requestId", (String)runId);
            compiledExecutionGraph.run();
            compiledExecutionGraph.join();
        }));
        MDC.remove((String)"requestId");
        res.status(200);
        return GSON.toJson((Object)new SubmitMessage(runId));
    }

    private Object handleShapes(Request req, Response res) throws IOException {
        res.type("text/turtle");
        res.header("Content-Disposition", "attachment; filename=shapes.ttl");
        res.status(200);
        SHAPES_MODEL.write((OutputStream)res.raw().getOutputStream(), "TTL");
        return "";
    }

    private Object handleStatus(Request req, Response res) {
        String id = Server.sanitizeId(req.params("id"));
        StatusMessage result = !this.requests.containsKey(id) ? new StatusMessage(-1, "Request ID not found") : (!((CompletableFuture)this.requests.get(id)).isDone() ? new StatusMessage(0, "Request is being processed") : (((CompletableFuture)this.requests.get(id)).isCompletedExceptionally() ? new StatusMessage(1, "Request completed exceptionally") : new StatusMessage(2, "Request has been processed successfully")));
        res.status(200);
        return GSON.toJson((Object)result);
    }

    private Object handleLogs(Request req, Response res) throws Exception {
        String id = Server.sanitizeId(req.params("id"));
        File requestedFile = new File(LOG_DIR_PATH + id + ".log");
        if (requestedFile.exists()) {
            boolean finish;
            res.type("text/plain");
            res.header("Content-Disposition", "attachment; filename=log.txt");
            res.status(200);
            ServletOutputStream os = res.raw().getOutputStream();
            FileInputStream fs = new FileInputStream(requestedFile);
            byte[] buffer = new byte[1024];
            boolean bl = finish = !this.requests.containsKey(id) || ((CompletableFuture)this.requests.get(id)).isDone();
            while (true) {
                int count;
                if ((count = fs.read(buffer)) >= 0) {
                    os.write(buffer, 0, count);
                    continue;
                }
                os.flush();
                if (finish) break;
                Thread.sleep(500L);
                finish = ((CompletableFuture)this.requests.get(id)).isDone();
            }
            fs.close();
            os.close();
            return "";
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Logfile not found"));
    }

    private Object handleResult(Request req, Response res) throws Exception {
        File file;
        String id = Server.sanitizeId(req.params("id"));
        File requestedFile = new File(STORAGE_DIR_PATH + id + "/" + (file = new File(req.params("file"))).getName());
        if (requestedFile.exists()) {
            int count;
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
            Collection mimeTypes = MimeUtil.getMimeTypes((File)requestedFile, (MimeType)new MimeType("text/plain"));
            res.type(mimeTypes.iterator().next().toString());
            res.header("Content-Disposition", "attachment; filename=" + file.getName());
            res.status(200);
            ServletOutputStream os = res.raw().getOutputStream();
            FileInputStream fs = new FileInputStream(requestedFile);
            byte[] buffer = new byte[1024];
            while ((count = fs.read(buffer)) >= 0) {
                os.write(buffer, 0, count);
            }
            os.flush();
            fs.close();
            os.close();
            return "";
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Result file not found"));
    }

    private Object handleResults(Request req, Response res) {
        String id = Server.sanitizeId(req.params("id"));
        File dir = new File(STORAGE_DIR_PATH + id);
        if (dir.exists() && dir.isDirectory()) {
            List<String> availableFiles = Arrays.stream(Objects.requireNonNull(dir.listFiles())).map(File::getName).collect(Collectors.toList());
            return GSON.toJson((Object)new ResultsMessage(availableFiles));
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Request ID not found"));
    }

    private static String sanitizeId(String id) {
        return id.replaceAll("[^0-9a-f\\-]", "");
    }

    private static void enableCORS(String origin, String methods, String headers) {
        Spark.options((String)"/*", (request, response) -> {
            String accessControlRequestMethod;
            String accessControlRequestHeaders = request.headers("Access-Control-Request-Headers");
            if (accessControlRequestHeaders != null) {
                response.header("Access-Control-Allow-Headers", accessControlRequestHeaders);
            }
            if ((accessControlRequestMethod = request.headers("Access-Control-Request-Method")) != null) {
                response.header("Access-Control-Allow-Methods", accessControlRequestMethod);
            }
            return "OK";
        });
        Spark.before((Filter[])new Filter[]{(request, response) -> {
            response.header("Access-Control-Allow-Origin", origin);
            response.header("Access-Control-Request-Method", methods);
            response.header("Access-Control-Allow-Headers", headers);
            response.type("application/json");
        }});
    }

    private static class ErrorMessage
    extends ServerMessage {
        private Error error;

        ErrorMessage(Throwable e) {
            this(-1, e.getMessage());
        }

        ErrorMessage(int code, String message) {
            this.success = false;
            this.error = new Error();
            this.error.code = code;
            this.error.message = message;
        }

        private static class Error {
            private int code;
            private String message;

            private Error() {
            }
        }
    }

    private static class SubmitMessage {
        private String requestId;

        private SubmitMessage(String requestId) {
            this.requestId = requestId;
        }
    }

    private static class StatusMessage {
        private Status status = new Status();

        private StatusMessage(int status, String description) {
            this.status.code = status;
            this.status.description = description;
        }

        private static class Status {
            int code;
            String description;

            private Status() {
            }
        }
    }

    private static class ResultsMessage {
        private List<String> availableFiles;

        private ResultsMessage(List<String> availableFiles) {
            this.availableFiles = availableFiles;
        }
    }

    private static class ServerMessage {
        protected boolean success = true;

        private ServerMessage() {
        }
    }
}

