/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.aksw.deer.Deer;
import org.aksw.deer.DeerAnalyticsStore;
import org.aksw.deer.DeerExecutionNodeWrapper;
import org.aksw.deer.enrichments.EnrichmentOperator;
import org.aksw.deer.io.ModelReader;
import org.aksw.deer.io.ModelWriter;
import org.aksw.deer.server.Server;
import org.aksw.faraday_cage.engine.CompiledExecutionGraph;
import org.aksw.faraday_cage.engine.FaradayCageContext;
import org.aksw.faraday_cage.engine.PluginFactory;
import org.aksw.faraday_cage.vocabulary.FCAGE;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.ResourceFactory;
import org.fusesource.jansi.Ansi;
import org.json.JSONObject;
import org.pf4j.DefaultPluginManager;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.topbraid.shacl.validation.sparql.AbstractSPARQLExecutor;

public class DeerController {
    private static final Logger logger;
    private static final String HELP_MSG = "deer [OPTION]... <config_file_or_uri>";
    private static final Integer DEFAULT_PORT;
    private static final Options OPTIONS;
    private static final PluginManager pluginManager;
    private static final FaradayCageContext executionContext;

    public static FaradayCageContext getExecutionContext() {
        return executionContext;
    }

    public static void main(String[] args) {
        CommandLine cl = DeerController.parseCommandLine(args);
        if (cl.hasOption('h')) {
            DeerController.printHelp();
        } else if (cl.hasOption('l')) {
            PrintStream out = System.out;
            out.println(EnrichmentOperator.class.getSimpleName() + ":");
            new PluginFactory(EnrichmentOperator.class, pluginManager, FCAGE.ExecutionNode).listAvailable().forEach(out::println);
            out.println(ModelReader.class.getSimpleName() + ":");
            new PluginFactory(ModelReader.class, pluginManager, FCAGE.ExecutionNode).listAvailable().forEach(out::println);
            out.println(ModelWriter.class.getSimpleName() + ":");
            new PluginFactory(ModelWriter.class, pluginManager, FCAGE.ExecutionNode).listAvailable().forEach(out::println);
            out.println(DeerExecutionNodeWrapper.class.getSimpleName() + ":");
            new PluginFactory(DeerExecutionNodeWrapper.class, pluginManager, FCAGE.ExecutionNode).listAvailable().forEach(out::println);
        } else if (cl.hasOption('v')) {
            PrintStream out = System.out;
            Object id = cl.getOptionValue('v', "");
            if (!((String)id).isEmpty()) {
                if (((String)id).startsWith("deer:")) {
                    id = "http://w3id.org/deer/" + ((String)id).substring(5);
                }
                executionContext.getValidationModelFor(ResourceFactory.createResource((String)id)).write((OutputStream)out, "TTL");
            } else {
                executionContext.getFullValidationModel().write((OutputStream)out, "TTL");
            }
        } else if (cl.hasOption('s')) {
            Integer port;
            Integer n = port = cl.hasOption('p') ? cl.getOptionObject('p') : DEFAULT_PORT;
            if (port == null) {
                DeerController.exitWithError("Expected a number as argument for option: p");
            } else {
                DeerController.runDeerServer(((Number)port).intValue());
            }
        } else if (cl.getArgList().size() == 0) {
            DeerController.exitWithError("Please specify a configuration file to use!");
        } else {
            if (cl.hasOption('E')) {
                AbstractSPARQLExecutor.createDetails = true;
            }
            DeerController.runDeer(DeerController.compileDeer((String)cl.getArgList().get(0)));
        }
    }

    private static CommandLine parseCommandLine(String[] args) {
        DefaultParser parser = new DefaultParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(OPTIONS, args, false);
        }
        catch (ParseException e) {
            DeerController.exitWithError(e.getMessage());
        }
        return cl;
    }

    private static void exitWithError(String errorMsg) {
        System.out.println(Ansi.ansi().fg(Ansi.Color.RED).a("Error:\n\t" + errorMsg).reset());
        DeerController.printHelp();
        System.exit(1);
    }

    private static void printHelp() {
        new HelpFormatter().printHelp(HELP_MSG, OPTIONS);
    }

    private static void runDeerServer(int port) {
        logger.info("Trying to start DEER server on 0.0.0.0:{} ...", (Object)port);
        Server.getInstance().run(port);
    }

    public static CompiledExecutionGraph compileDeer(String fileName, String runId) {
        logger.info("Trying to read DEER configuration from file {}...", (Object)fileName);
        try {
            Model configurationModel = ModelFactory.createDefaultModel();
            long startTime = System.currentTimeMillis();
            configurationModel.read(fileName);
            logger.info("Loading {} is done in {}ms.", (Object)fileName, (Object)(System.currentTimeMillis() - startTime));
            return executionContext.compile(configurationModel, runId);
        }
        catch (HttpException e) {
            throw new RuntimeException("Encountered HTTPException trying to load model from " + fileName, e);
        }
    }

    public static CompiledExecutionGraph compileDeer(String fileName) {
        logger.info("Trying to read DEER configuration from file {}...", (Object)fileName);
        try {
            Model configurationModel = ModelFactory.createDefaultModel();
            long startTime = System.currentTimeMillis();
            configurationModel.read(fileName);
            logger.info("Loading {} is done in {}ms.", (Object)fileName, (Object)(System.currentTimeMillis() - startTime));
            return executionContext.compile(configurationModel);
        }
        catch (HttpException e) {
            throw new RuntimeException("Encountered HTTPException trying to load model from " + fileName, e);
        }
    }

    private static void runDeer(CompiledExecutionGraph compiledExecutionGraph) {
        compiledExecutionGraph.andThen(() -> DeerController.writeAnalytics(Paths.get("deer-analytics.json", new String[0]).toAbsolutePath()));
        executionContext.run(compiledExecutionGraph);
    }

    public static void writeAnalytics(Path analyticsFile) {
        try {
            logger.info("Trying to write analytics data to " + analyticsFile);
            BufferedWriter writer = Files.newBufferedWriter(analyticsFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            JSONObject analyticsForJob = DeerAnalyticsStore.getAnalyticsForJob((String)FaradayCageContext.getRunId());
            analyticsForJob.write((Writer)writer, 2, 0);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            logger.error("Error! Could not write analytics file!");
            e.printStackTrace();
        }
    }

    static {
        MDC.put((String)"requestId", (String)"main");
        logger = LoggerFactory.getLogger(DeerController.class);
        DEFAULT_PORT = 8080;
        OPTIONS = new Options().addOption(Option.builder((String)"h").longOpt("help").desc("show help message").build()).addOption(Option.builder((String)"l").longOpt("list").desc("list available deer plugins").build()).addOption(Option.builder((String)"E").longOpt("explain").desc("enable detailed explanation of graph validation").build()).addOption(Option.builder((String)"v").longOpt("validation-graph").desc("if $plugin_id is provided, get SHACL validation graph for $plugin_id, else get the complete validation graph.").hasArg().argName("plugin_id").optionalArg(true).build()).addOption(Option.builder((String)"s").longOpt("server").desc("launch server").build()).addOption(Option.builder((String)"p").longOpt("port").desc("set port for server to listen on").hasArg().argName("port_number").type(Number.class).build());
        pluginManager = new DefaultPluginManager();
        File plugins = new File("./plugins/");
        if (plugins.exists() && plugins.isDirectory()) {
            pluginManager.loadPlugins();
            pluginManager.startPlugins();
        }
        executionContext = Deer.getExecutionContext((PluginManager)pluginManager);
    }
}

