/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.deer.Deer;
import org.aksw.deer.DeerPlugin;
import org.aksw.deer.logging.MdcCompletableFuture;
import org.aksw.deer.server.Server;
import org.aksw.deer.util.JavadocPrinter;
import org.aksw.faraday_cage.PluginFactory;
import org.aksw.faraday_cage.Vocabulary;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.fusesource.jansi.Ansi;
import org.pf4j.DefaultPluginManager;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DeerController {
    private static final Logger logger;
    private static final String HELP_MSG = "deer [OPTION]... <config_file_or_uri>";
    private static final Integer DEFAULT_PORT;
    private static final Options OPTIONS;
    private static final PluginManager pluginManager;

    public static void main(String[] args) {
        Vocabulary.setDefaultURI((String)"http://deer.aksw.org/vocabulary/#");
        Vocabulary.addNSPrefix((String)"", (String)"http://deer.aksw.org/vocabulary/#");
        CommandLine cl = DeerController.parseCommandLine(args);
        if (cl.hasOption('h')) {
            DeerController.printHelp();
        } else if (cl.hasOption('l')) {
            PluginFactory factory = new PluginFactory(DeerPlugin.class, pluginManager);
            factory.listAvailable().forEach(System.out::println);
        } else if (cl.hasOption('e')) {
            PluginFactory factory = new PluginFactory(DeerPlugin.class, pluginManager);
            Resource pluginId = Vocabulary.resource((String)cl.getOptionValue('e'));
            List filteredPluginId = factory.listAvailable().stream().filter(r -> r.equals((Object)pluginId)).collect(Collectors.toList());
            if (filteredPluginId.size() == 1) {
                DeerPlugin plugin = (DeerPlugin)factory.create((Resource)filteredPluginId.get(0));
                JavadocPrinter.printJavadoc((String)plugin.getClass().getCanonicalName());
            } else {
                DeerController.exitWithError("Could not find deer plugin " + pluginId + ", please use -l option to list all available.");
            }
        } else if (cl.hasOption('s')) {
            Integer port;
            Integer n = port = cl.hasOption('p') ? cl.getOptionObject('p') : DEFAULT_PORT;
            if (port == null) {
                DeerController.exitWithError("Expected a number as argument for option: p");
            } else {
                DeerController.runDeerServer(((Number)port).intValue());
            }
        } else if (cl.getArgList().size() == 0) {
            DeerController.exitWithError("Please specify a configuration file to use!");
        } else {
            DeerController.runDeer((String)cl.getArgList().get(0));
        }
    }

    private static CommandLine parseCommandLine(String[] args) {
        DefaultParser parser = new DefaultParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(OPTIONS, args, false);
        }
        catch (ParseException e) {
            DeerController.exitWithError(e.getMessage());
        }
        return cl;
    }

    private static void exitWithError(String errorMsg) {
        System.out.println(Ansi.ansi().fg(Ansi.Color.RED).a("Error:\n\t" + errorMsg).reset());
        DeerController.printHelp();
        System.exit(1);
    }

    private static void printHelp() {
        new HelpFormatter().printHelp(HELP_MSG, OPTIONS);
    }

    private static void runDeerServer(int port) {
        logger.info("Trying to start DEER server on 0.0.0.0:{} ...", (Object)port);
        Server.getInstance().run(port);
    }

    public static void runDeer(String fileName) {
        logger.info("Trying to read DEER configuration from file {}...", (Object)fileName);
        try {
            Model model = ModelFactory.createDefaultModel();
            long startTime = System.currentTimeMillis();
            model.read(fileName);
            logger.info("Loading {} is done in {}ms.", (Object)fileName, (Object)(System.currentTimeMillis() - startTime));
            DeerController.runDeer(model);
        }
        catch (HttpException e) {
            throw new RuntimeException("Encountered HTTPException trying to load model from " + fileName, e);
        }
    }

    private static void runDeer(Model configurationModel) {
        new Deer().run(configurationModel, pluginManager, MdcCompletableFuture.Factory.INSTANCE);
    }

    static {
        MDC.put((String)"requestId", (String)"main");
        logger = LoggerFactory.getLogger(DeerController.class);
        DEFAULT_PORT = 8080;
        OPTIONS = new Options().addOption(Option.builder((String)"h").longOpt("help").desc("show help message").build()).addOption(Option.builder((String)"l").longOpt("list").desc("list available deer plugins").build()).addOption(Option.builder((String)"e").longOpt("explain").desc("show deer plugin documentation").hasArg().argName("plugin_id").build()).addOption(Option.builder((String)"s").longOpt("server").desc("launch server").build()).addOption(Option.builder((String)"p").longOpt("port").desc("set port for server to listen on").hasArg().argName("port_number").type(Number.class).build());
        pluginManager = new DefaultPluginManager();
        File plugins = new File("./plugins/");
        if (plugins.exists() && plugins.isDirectory()) {
            pluginManager.loadPlugins();
            pluginManager.startPlugins();
        }
    }
}

