/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Part;
import org.aksw.deer.DeerController;
import org.aksw.deer.io.AbstractModelIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import spark.Filter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class Server {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    public static final String STORAGE_DIR_PATH = "./.server-storage/";
    public static final String LOG_DIR_PATH = "./.server-storage/logs/";
    public static final String CONFIG_FILE_PREFIX = "deer_cfg_";
    public static final String CONFIG_FILE_SUFFIX = ".ttl";
    private static final Gson GSON = new GsonBuilder().create();
    private static Server instance = null;
    private final Map<String, CompletableFuture<Void>> requests = new HashMap<String, CompletableFuture<Void>>();
    private final File uploadDir = new File("./.server-storage/");
    private int port = -1;

    public static Server getInstance() {
        if (instance == null) {
            instance = new Server();
        }
        return instance;
    }

    public void run(int port) {
        if (this.port > 0) {
            throw new IllegalStateException("Server already running on port " + port + "!");
        }
        this.port = port;
        AbstractModelIO.takeWorkingDirectoryFrom(() -> STORAGE_DIR_PATH + MDC.get((String)"requestId") + "/");
        if (!this.uploadDir.exists()) {
            this.uploadDir.mkdir();
        }
        Spark.threadPool((int)8, (int)1, (int)30000);
        Spark.port((int)port);
        Server.enableCORS("*", "GET, POST, OPTIONS", "");
        Spark.post((String)"/submit", this::handleSubmit);
        Spark.get((String)"/status/:id", this::handleStatus);
        Spark.get((String)"/logs/:id", this::handleLogs);
        Spark.get((String)"/results/:id", this::handleResults);
        Spark.get((String)"/result/:id/:file", this::handleResult);
        Spark.exception(Exception.class, (e, req, res) -> {
            logger.error("Error in processing request" + req.uri(), (Throwable)e);
            res.status(500);
            res.type("application/json");
            res.body(GSON.toJson((Object)new ErrorMessage(e)));
        });
        Spark.notFound((req, res) -> {
            res.type("application/json");
            res.status(404);
            return GSON.toJson((Object)new ErrorMessage(-2, "Route not known"));
        });
        Spark.init();
        Spark.awaitInitialization();
    }

    private Server() {
    }

    private Object handleSubmit(Request req, Response res) throws Exception {
        Path tempFile = Files.createTempFile(this.uploadDir.toPath(), CONFIG_FILE_PREFIX, CONFIG_FILE_SUFFIX, new FileAttribute[0]);
        req.attribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement("/temp"));
        try (InputStream is = req.raw().getPart("config_file").getInputStream();){
            Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        logger.info("Uploaded file '{}' saved as '{}'", (Object)Server.getFileName(req.raw().getPart("config_file")), (Object)tempFile.toAbsolutePath());
        String id = tempFile.toString();
        id = id.substring(id.indexOf(CONFIG_FILE_PREFIX) + CONFIG_FILE_PREFIX.length(), id.lastIndexOf(CONFIG_FILE_SUFFIX));
        File workingDir = new File(this.uploadDir.getAbsoluteFile(), id);
        if (!workingDir.mkdir()) {
            throw new RuntimeException("Not able to create directory " + workingDir.getAbsolutePath());
        }
        String requestId = id;
        this.requests.put(requestId, (CompletableFuture<Void>)CompletableFuture.completedFuture(null).thenAcceptAsync($ -> {
            MDC.put((String)"requestId", (String)requestId);
            DeerController.runDeer(tempFile.toString());
        }));
        res.status(200);
        return GSON.toJson((Object)new SubmitMessage(id));
    }

    private Object handleStatus(Request req, Response res) {
        String id = Server.sanitizeId(req.params("id"));
        StatusMessage result = !this.requests.containsKey(id) ? new StatusMessage(-1, "Request ID not found") : (!this.requests.get(id).isDone() ? new StatusMessage(0, "Request is being processed") : new StatusMessage(1, "Request has been processed"));
        res.status(200);
        return GSON.toJson((Object)result);
    }

    private Object handleLogs(Request req, Response res) throws Exception {
        String id = Server.sanitizeId(req.params("id"));
        File requestedFile = new File(LOG_DIR_PATH + id + ".log");
        if (requestedFile.exists()) {
            boolean finish;
            res.type("text/plain");
            res.header("Content-Disposition", "attachment; filename=log.txt");
            res.status(200);
            ServletOutputStream os = res.raw().getOutputStream();
            FileInputStream fs = new FileInputStream(requestedFile);
            byte[] buffer = new byte[1024];
            boolean bl = finish = !this.requests.containsKey(id) || this.requests.get(id).isDone();
            while (true) {
                int count;
                if ((count = fs.read(buffer)) >= 0) {
                    os.write(buffer, 0, count);
                    continue;
                }
                os.flush();
                if (finish) break;
                Thread.sleep(500L);
                finish = this.requests.get(id).isDone();
            }
            fs.close();
            os.close();
            return "";
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Logfile not found"));
    }

    private Object handleResult(Request req, Response res) throws Exception {
        File file;
        String id = Server.sanitizeId(req.params("id"));
        File requestedFile = new File(STORAGE_DIR_PATH + id + "/" + (file = new File(req.params("file"))).getName());
        if (requestedFile.exists()) {
            int count;
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
            Collection mimeTypes = MimeUtil.getMimeTypes((File)requestedFile, (MimeType)new MimeType("text/plain"));
            res.type(mimeTypes.iterator().next().toString());
            res.header("Content-Disposition", "attachment; filename=" + file.getName());
            res.status(200);
            ServletOutputStream os = res.raw().getOutputStream();
            FileInputStream fs = new FileInputStream(requestedFile);
            byte[] buffer = new byte[1024];
            while ((count = fs.read(buffer)) >= 0) {
                os.write(buffer, 0, count);
            }
            os.flush();
            fs.close();
            os.close();
            return "";
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Result file not found"));
    }

    private Object handleResults(Request req, Response res) {
        String id = Server.sanitizeId(req.params("id"));
        File dir = new File(STORAGE_DIR_PATH + id);
        if (dir.exists() && dir.isDirectory()) {
            List availableFiles = Arrays.stream(Objects.requireNonNull(dir.listFiles())).map(File::getName).collect(Collectors.toList());
            return GSON.toJson((Object)new ResultsMessage(availableFiles));
        }
        res.status(404);
        return GSON.toJson((Object)new ErrorMessage(1, "Request ID not found"));
    }

    private static String sanitizeId(String id) {
        return id.replaceAll("[^\\d]", "");
    }

    private static String getFileName(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return "config.ttl";
    }

    private static void enableCORS(String origin, String methods, String headers) {
        Spark.options((String)"/*", (request, response) -> {
            String accessControlRequestMethod;
            String accessControlRequestHeaders = request.headers("Access-Control-Request-Headers");
            if (accessControlRequestHeaders != null) {
                response.header("Access-Control-Allow-Headers", accessControlRequestHeaders);
            }
            if ((accessControlRequestMethod = request.headers("Access-Control-Request-Method")) != null) {
                response.header("Access-Control-Allow-Methods", accessControlRequestMethod);
            }
            return "OK";
        });
        Spark.before((Filter[])new Filter[]{(request, response) -> {
            response.header("Access-Control-Allow-Origin", origin);
            response.header("Access-Control-Request-Method", methods);
            response.header("Access-Control-Allow-Headers", headers);
            response.type("application/json");
        }});
    }

    private static class SubmitMessage {
        private String requestId;

        private SubmitMessage(String requestId) {
            this.requestId = requestId;
        }
    }

    private static class ResultsMessage {
        private List<String> availableFiles;

        private ResultsMessage(List<String> availableFiles) {
            this.availableFiles = availableFiles;
        }
    }

    private static class StatusMessage {
        private Status status = new Status();

        private StatusMessage(int status, String description) {
            this.status.code = status;
            this.status.description = description;
        }

        private static class Status {
            int code;
            String description;

            private Status() {
            }
        }
    }

    private static class ErrorMessage
    extends ServerMessage {
        private Error error;

        ErrorMessage(Throwable e) {
            this(-1, e.getMessage());
        }

        ErrorMessage(int code, String message) {
            this.success = false;
            this.error = new Error();
            this.error.code = code;
            this.error.message = message;
        }

        private static class Error {
            private int code;
            private String message;

            private Error() {
            }
        }
    }

    private static class ServerMessage {
        protected boolean success = true;

        private ServerMessage() {
        }
    }
}

