/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.logging;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.MDC;

public class MdcThreadPoolExecutor
extends ForkJoinPool {
    private final boolean useFixedContext;
    private final Map<String, String> fixedContext;

    public static MdcThreadPoolExecutor newWithInheritedMdc(int parallelism) {
        return new MdcThreadPoolExecutor(null, parallelism);
    }

    public static MdcThreadPoolExecutor newWithCurrentMdc(int parallelism) {
        return new MdcThreadPoolExecutor(MDC.getCopyOfContextMap(), parallelism);
    }

    public static MdcThreadPoolExecutor newWithFixedMdc(Map<String, String> fixedContext, int parallelism) {
        return new MdcThreadPoolExecutor(fixedContext, parallelism);
    }

    private MdcThreadPoolExecutor(Map<String, String> fixedContext, int parallelism) {
        super(parallelism);
        this.fixedContext = fixedContext;
        this.useFixedContext = fixedContext != null;
    }

    @Override
    public void execute(Runnable command) {
        super.execute(MdcThreadPoolExecutor.wrap(command, this.getContextForTask()));
    }

    @Override
    @NotNull
    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        return super.submit((Callable)MdcThreadPoolExecutor.wrap(task, this.getContextForTask()));
    }

    @Override
    @NotNull
    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        return super.submit(MdcThreadPoolExecutor.wrap(task, this.getContextForTask()), (Object)result);
    }

    @Override
    @NotNull
    public ForkJoinTask<?> submit(Runnable task) {
        return super.submit(MdcThreadPoolExecutor.wrap(task, this.getContextForTask()));
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException("Operation not implemented.");
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Operation not implemented.");
    }

    @Override
    @NotNull
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException("Operation not implemented.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Operation not implemented.");
    }

    private static Runnable wrap(Runnable runnable, Map<String, String> context) {
        return () -> {
            Map previous = MDC.getCopyOfContextMap();
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            try {
                runnable.run();
            }
            finally {
                if (previous == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap((Map)previous);
                }
            }
        };
    }

    private static <V> Callable<V> wrap(Callable<V> callable, Map<String, String> context) {
        return () -> {
            Object call;
            Map previous = MDC.getCopyOfContextMap();
            if (context == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)context);
            }
            try {
                call = callable.call();
            }
            finally {
                if (previous == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap((Map)previous);
                }
            }
            return call;
        };
    }

    private Map<String, String> getContextForTask() {
        return this.useFixedContext ? this.fixedContext : MDC.getCopyOfContextMap();
    }
}

