/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.deer.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.aksw.deer.logging.MdcThreadPoolExecutor;
import org.aksw.faraday_cage.CompletableFutureFactory;
import org.slf4j.MDC;

public class MdcCompletableFuture<T>
extends CompletableFuture<T> {
    private static final int PARALLELISM;
    private static final String DEER_PARALLELISM_LEVEL = "deerParallelismLevel";
    private static final Map<String, Executor> MDC_EXEC_MAP;
    private static final Executor DEFAULT_EXEC;

    public static <U> CompletableFuture<U> completedFuture(U value) {
        MdcCompletableFuture<U> x = new MdcCompletableFuture<U>();
        x.complete(value);
        return x;
    }

    @Override
    public Executor defaultExecutor() {
        String requestId = MDC.get((String)"requestId");
        if (MDC.get((String)"requestId") == null) {
            return DEFAULT_EXEC;
        }
        if (!MDC_EXEC_MAP.containsKey(requestId)) {
            MDC_EXEC_MAP.put(requestId, MdcThreadPoolExecutor.newWithInheritedMdc(PARALLELISM));
        }
        return MDC_EXEC_MAP.get(requestId);
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        return new MdcCompletableFuture<T>();
    }

    static {
        int parallelism = Runtime.getRuntime().availableProcessors();
        if (System.getProperty(DEER_PARALLELISM_LEVEL) != null) {
            parallelism = Integer.parseInt(System.getProperty(DEER_PARALLELISM_LEVEL));
        }
        PARALLELISM = parallelism;
        MDC_EXEC_MAP = new HashMap<String, Executor>();
        DEFAULT_EXEC = MdcThreadPoolExecutor.newWithInheritedMdc(PARALLELISM);
    }

    public static class Factory
    implements CompletableFutureFactory {
        public static final CompletableFutureFactory INSTANCE = new Factory();

        private Factory() {
        }

        public <T> CompletableFuture<T> getInstance() {
            return new MdcCompletableFuture();
        }

        public <T> CompletableFuture<T> getCompletedInstance(T value) {
            return MdcCompletableFuture.completedFuture(value);
        }
    }
}

