/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.servlets;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestParamHandler {
    private static final String ATTRIBUTE_NAME_IS_HANDLED = "OutputRequestParamHandler.isHandled";
    private static final Map<String, String> mimeTypes = new HashMap<String, String>();
    private final HttpServletRequest request;
    private final String requestedType;

    public static String removeOutputRequestParam(String uri) {
        return uri.replaceFirst("([?&]output=[a-z0-9]*$)|((?<=[?&])output=[a-z0-9]*&)", "");
    }

    public RequestParamHandler(HttpServletRequest request) {
        this.request = request;
        this.requestedType = this.identifyRequestedType(request.getParameter("output"));
    }

    public boolean isMatchingRequest() {
        if ("true".equals(this.request.getAttribute(ATTRIBUTE_NAME_IS_HANDLED))) {
            return false;
        }
        return this.requestedType != null;
    }

    public HttpServletRequest getModifiedRequest() {
        return new WrappedRequest();
    }

    private String identifyRequestedType(String parameterValue) {
        if (mimeTypes.containsKey(parameterValue)) {
            return parameterValue;
        }
        return null;
    }

    static {
        mimeTypes.put("rdfxml", "application/rdf+xml");
        mimeTypes.put("xml", "application/rdf+xml");
        mimeTypes.put("ttl", "text/rdf+n3;charset=utf-8");
        mimeTypes.put("turtle", "text/rdf+n3;charset=utf-8");
        mimeTypes.put("n3", "text/rdf+n3;charset=utf-8");
        mimeTypes.put("nt", "text/plain");
        mimeTypes.put("text", "text/plain");
    }

    private class WrappedRequest
    extends HttpServletRequestWrapper {
        WrappedRequest() {
            super(RequestParamHandler.this.request);
            this.setAttribute(RequestParamHandler.ATTRIBUTE_NAME_IS_HANDLED, "true");
        }

        public String getHeader(String name) {
            if ("accept".equals(name.toLowerCase())) {
                return (String)mimeTypes.get(RequestParamHandler.this.requestedType);
            }
            return super.getHeader(name);
        }

        public Enumeration getHeaderNames() {
            final Enumeration realHeaders = super.getHeaderNames();
            return new Enumeration(){
                private String prefetched = null;

                @Override
                public boolean hasMoreElements() {
                    while (this.prefetched == null && realHeaders.hasMoreElements()) {
                        String next = (String)realHeaders.nextElement();
                        if ("accept".equals(next.toLowerCase())) continue;
                        this.prefetched = next;
                    }
                    return this.prefetched != null;
                }

                public Object nextElement() {
                    return this.prefetched;
                }
            };
        }

        public Enumeration getHeaders(String name) {
            if ("accept".equals(name.toLowerCase())) {
                Vector<String> v = new Vector<String>();
                v.add(this.getHeader(name));
                return v.elements();
            }
            return super.getHeaders(name);
        }
    }
}

