/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.servlets;

import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.HypermediaResource;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.ModelResponse;
import de.fuberlin.wiwiss.pubby.ResourceDescription;
import de.fuberlin.wiwiss.pubby.servlets.BaseURLServlet;
import de.fuberlin.wiwiss.pubby.vocab.FOAF;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDFS;

public class DataURLServlet
extends BaseURLServlet {
    private static final long serialVersionUID = 6825866213915066364L;

    @Override
    protected boolean doGet(HypermediaResource controller, Collection<MappedResource> resources, HttpServletRequest request, HttpServletResponse response, Configuration config) throws IOException {
        Object pathDataURL;
        Statement stmt;
        Model description = this.getResourceDescription(resources);
        if (description.size() == 0L) {
            response.setStatus(404);
            response.setContentType("text/plain");
            response.getOutputStream().println("Nothing known about <" + controller.getAbsoluteIRI() + ">");
            return true;
        }
        Resource r = description.getResource(controller.getAbsoluteIRI());
        StmtIterator it = r.listProperties();
        while (it.hasNext()) {
            stmt = it.nextStatement();
            if (!stmt.getObject().isAnon()) continue;
            pathDataURL = controller.getPathDataURL(stmt.getPredicate());
            stmt.getResource().addProperty(RDFS.seeAlso, (RDFNode)description.createResource((String)pathDataURL));
        }
        it = description.listStatements(null, null, (RDFNode)r);
        while (it.hasNext()) {
            stmt = it.nextStatement();
            if (!stmt.getSubject().isAnon()) continue;
            pathDataURL = controller.getInversePathDataURL(stmt.getPredicate());
            ((Resource)stmt.getSubject().as(Resource.class)).addProperty(RDFS.seeAlso, (RDFNode)description.createResource((String)pathDataURL));
        }
        if (description.qnameFor(FOAF.primaryTopic.getURI()) == null && description.getNsPrefixURI("foaf") == null) {
            description.setNsPrefix("foaf", "http://xmlns.com/foaf/0.1/");
        }
        if (description.qnameFor(RDFS.label.getURI()) == null && description.getNsPrefixURI("rdfs") == null) {
            description.setNsPrefix("rdfs", RDFS.getURI());
        }
        Resource document = description.getResource(this.addQueryString(controller.getDataURL(), request));
        document.addProperty(FOAF.primaryTopic, (RDFNode)r);
        document.addProperty(RDFS.label, "RDF description of " + new ResourceDescription(controller, description, config).getLabel());
        for (MappedResource resource : resources) {
            resource.getDataset().addDocumentMetadata(description, document);
            resource.getDataset().addMetadataFromTemplate(description, resource, this.getServletContext());
        }
        ModelResponse server = new ModelResponse(description, request, response);
        server.serve();
        return true;
    }
}

