/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.servlets;

import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.ModelTranslator;
import de.fuberlin.wiwiss.pubby.ModelUtil;
import de.fuberlin.wiwiss.pubby.servlets.VelocityHelper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.FileManager;
import org.apache.jena.vocabulary.OWL;
import org.apache.velocity.context.Context;

public abstract class BaseServlet
extends HttpServlet {
    private static final String SERVER_CONFIGURATION = BaseServlet.class.getName() + ".serverConfiguration";
    private Configuration config;
    private static final long serialVersionUID = 7594710471966527559L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        synchronized (servletContext) {
            if (this.getServletContext().getAttribute(SERVER_CONFIGURATION) == null) {
                this.getServletContext().setAttribute(SERVER_CONFIGURATION, (Object)this.createServerConfiguration());
            }
        }
        this.config = (Configuration)this.getServletContext().getAttribute(SERVER_CONFIGURATION);
    }

    private Configuration createServerConfiguration() throws UnavailableException {
        String param = this.getServletContext().getInitParameter("config-file");
        if (param == null) {
            throw new UnavailableException("Missing context parameter 'config-file'");
        }
        File configFile = new File(param);
        if (!configFile.isAbsolute()) {
            configFile = new File(this.getServletContext().getRealPath("/") + "/WEB-INF/" + param);
        }
        return new Configuration(FileManager.get().loadModel(configFile.getAbsoluteFile().toURI().toString()));
    }

    protected Model getResourceDescription(Collection<MappedResource> resources) {
        Model result = ModelFactory.createDefaultModel();
        for (MappedResource resource : resources) {
            Model description = new ModelTranslator(resource.getDataset().getDataSource().getResourceDescription(resource.getDatasetURI()), resource.getDataset(), this.config).getTranslated();
            if (resource.getDataset().getAddSameAsStatements()) {
                description.getResource(resource.getController().getAbsoluteIRI()).addProperty(OWL.sameAs, (RDFNode)description.getResource(resource.getDatasetURI()));
                ModelUtil.addNSIfUndefined((PrefixMapping)description, "owl", "http://www.w3.org/2002/07/owl#");
            }
            ModelUtil.mergeModels(result, description);
        }
        return result;
    }

    protected Model getAnonymousPropertyValues(Collection<MappedResource> resources, Property property, boolean isInverse) {
        Model result = ModelFactory.createDefaultModel();
        for (MappedResource resource : resources) {
            ModelUtil.mergeModels(result, new ModelTranslator(resource.getDataset().getDataSource().getAnonymousPropertyValues(resource.getDatasetURI(), property, isInverse), resource.getDataset(), this.config).getTranslated());
        }
        return result;
    }

    protected String getFirstSPARQLEndpoint(Collection<MappedResource> resources) {
        for (MappedResource resource : resources) {
            if (resource.getDataset().getDataSource().getEndpointURL() == null) continue;
            return resource.getDataset().getDataSource().getEndpointURL();
        }
        return null;
    }

    protected abstract boolean doGet(String var1, HttpServletRequest var2, HttpServletResponse var3, Configuration var4) throws IOException, ServletException;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String relativeURI = request.getRequestURI().substring(request.getContextPath().length() + request.getServletPath().length());
        if (!"".equals(relativeURI) && "/".equals(relativeURI.substring(0, 1))) {
            relativeURI = relativeURI.substring(1);
        }
        if (!this.doGet(relativeURI, request, response, this.config)) {
            this.send404(response, null);
        }
    }

    protected void send404(HttpServletResponse response, String resourceURI) throws IOException {
        response.setStatus(404);
        VelocityHelper template = new VelocityHelper(this.getServletContext(), response);
        Context context = template.getVelocityContext();
        context.put("project_name", (Object)this.config.getProjectName());
        context.put("project_link", (Object)this.config.getProjectLink());
        context.put("server_base", (Object)this.config.getWebApplicationBaseURI());
        context.put("title", (Object)"404 Not Found");
        if (resourceURI != null) {
            context.put("uri", (Object)resourceURI);
        }
        template.renderXHTML("404.vm");
    }

    protected String addQueryString(String dataURL, HttpServletRequest request) {
        if (request.getParameter("output") == null) {
            return dataURL;
        }
        return dataURL + "?output=" + request.getParameter("output");
    }
}

