/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.servlets;

import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.HypermediaResource;
import de.fuberlin.wiwiss.pubby.IRIEncoder;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.servlets.BaseServlet;
import java.io.IOException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.ResourceFactory;

public abstract class BasePathServlet
extends BaseServlet {
    private static Pattern pattern = Pattern.compile("(-?)([^:/]*):([^:/]*)/(.*)");
    private static final long serialVersionUID = 7393467141233996715L;

    public abstract boolean doGet(HypermediaResource var1, Collection<MappedResource> var2, Property var3, boolean var4, HttpServletRequest var5, HttpServletResponse var6, Configuration var7) throws IOException, ServletException;

    @Override
    public boolean doGet(String relativeURI, HttpServletRequest request, HttpServletResponse response, Configuration config) throws IOException, ServletException {
        Matcher matcher = pattern.matcher(relativeURI);
        if (!matcher.matches()) {
            return false;
        }
        boolean isInverse = "-".equals(matcher.group(1));
        String prefix = matcher.group(2);
        String localName = matcher.group(3);
        if (config.getPrefixes().getNsPrefixURI(prefix) == null) {
            return false;
        }
        Property property = ResourceFactory.createProperty((String)config.getPrefixes().getNsPrefixURI(prefix), (String)localName);
        Collection<MappedResource> resources = config.getMappedResourcesFromRelativeWebURI(matcher.group(4), false);
        HypermediaResource controller = config.getController(IRIEncoder.toIRI(matcher.group(4)), false);
        this.doGet(controller, resources, property, isInverse, request, response, config);
        return true;
    }
}

