/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.shared.PrefixMapping;

public class URIPrefixer {
    private final Resource resource;
    private final String prefix;
    private final String localName;

    public URIPrefixer(String uri, PrefixMapping prefixes) {
        this(ResourceFactory.createResource((String)uri), prefixes);
    }

    public URIPrefixer(Resource resource, PrefixMapping prefixes) {
        this.resource = resource;
        String uri = resource.getURI();
        for (String entryPrefix : prefixes.getNsPrefixMap().keySet()) {
            String entryURI = prefixes.getNsPrefixURI(entryPrefix);
            if (!uri.startsWith(entryURI)) continue;
            this.prefix = entryPrefix;
            this.localName = uri.substring(entryURI.length());
            return;
        }
        this.prefix = null;
        this.localName = null;
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        if (this.localName == null) {
            Matcher matcher = Pattern.compile("([^#/:?]+)[#/:?]*$").matcher(this.resource.getURI());
            if (matcher.find()) {
                return matcher.group(1);
            }
            return "";
        }
        return this.localName;
    }

    public String toTurtle() {
        if (this.hasPrefix()) {
            return this.getPrefix() + ":" + this.getLocalName();
        }
        return "<" + this.resource.getURI() + ">";
    }
}

