/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.HypermediaResource;
import de.fuberlin.wiwiss.pubby.URIPrefixer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;

public class ResourceDescription {
    private final HypermediaResource hypermediaResource;
    private final Model model;
    private final Resource resource;
    private final Configuration config;
    private PrefixMapping prefixes = null;
    private List<ResourceProperty> properties = null;

    public ResourceDescription(HypermediaResource resource, Model model, Configuration config) {
        this.hypermediaResource = resource;
        this.model = model;
        this.resource = model.getResource(this.hypermediaResource.getAbsoluteIRI());
        this.config = config;
    }

    public ResourceDescription(Resource resource, Model model, Configuration config) {
        this.hypermediaResource = null;
        this.model = model;
        this.resource = resource;
        this.config = config;
    }

    public String getURI() {
        return this.resource.getURI();
    }

    public String getLabel() {
        Collection<RDFNode> candidates = this.getValuesFromMultipleProperties(this.config.getLabelProperties());
        String label = this.getBestLanguageMatch(candidates, this.config.getDefaultLanguage());
        if (label == null) {
            return new URIPrefixer(this.resource, this.getPrefixes()).getLocalName();
        }
        return label;
    }

    public String getComment() {
        Collection<RDFNode> candidates = this.getValuesFromMultipleProperties(this.config.getCommentProperties());
        return this.getBestLanguageMatch(candidates, this.config.getDefaultLanguage());
    }

    public String getImageURL() {
        Collection<RDFNode> candidates = this.getValuesFromMultipleProperties(this.config.getImageProperties());
        for (RDFNode candidate : candidates) {
            if (!candidate.isURIResource()) continue;
            return ((Resource)candidate.as(Resource.class)).getURI();
        }
        return null;
    }

    public List<ResourceProperty> getProperties() {
        if (this.properties == null) {
            this.properties = this.buildProperties();
        }
        return this.properties;
    }

    private List<ResourceProperty> buildProperties() {
        String key;
        Property predicate;
        Statement stmt;
        HashMap<String, PropertyBuilder> propertyBuilders = new HashMap<String, PropertyBuilder>();
        StmtIterator it = this.resource.listProperties();
        while (it.hasNext()) {
            stmt = it.nextStatement();
            predicate = stmt.getPredicate();
            key = "=>" + predicate;
            if (!propertyBuilders.containsKey(key)) {
                propertyBuilders.put(key, new PropertyBuilder(predicate, false));
            }
            ((PropertyBuilder)propertyBuilders.get(key)).addValue(stmt.getObject());
        }
        it = this.model.listStatements(null, null, (RDFNode)this.resource);
        while (it.hasNext()) {
            stmt = it.nextStatement();
            predicate = stmt.getPredicate();
            key = "<=" + predicate;
            if (!propertyBuilders.containsKey(key)) {
                propertyBuilders.put(key, new PropertyBuilder(predicate, true));
            }
            ((PropertyBuilder)propertyBuilders.get(key)).addValue((RDFNode)stmt.getSubject());
        }
        ArrayList<ResourceProperty> results = new ArrayList<ResourceProperty>();
        for (PropertyBuilder propertyBuilder : propertyBuilders.values()) {
            results.add(propertyBuilder.toProperty());
        }
        Collections.sort(results);
        return results;
    }

    private PrefixMapping getPrefixes() {
        if (this.prefixes == null) {
            this.prefixes = new PrefixMappingImpl();
            this.prefixes.setNsPrefixes((PrefixMapping)this.model);
            for (String prefix : this.config.getPrefixes().getNsPrefixMap().keySet()) {
                this.prefixes.setNsPrefix(prefix, this.config.getPrefixes().getNsPrefixURI(prefix));
            }
        }
        return this.prefixes;
    }

    private Collection<RDFNode> getValuesFromMultipleProperties(Collection<Property> properties) {
        ArrayList<RDFNode> results = new ArrayList<RDFNode>();
        for (Property property : properties) {
            StmtIterator labelIt = this.resource.listProperties(property);
            while (labelIt.hasNext()) {
                RDFNode label = labelIt.nextStatement().getObject();
                results.add(label);
            }
        }
        return results;
    }

    private String getBestLanguageMatch(Collection<RDFNode> nodes, String lang) {
        Iterator<RDFNode> it = nodes.iterator();
        String aLiteral = null;
        while (it.hasNext()) {
            RDFNode candidate = it.next();
            if (!candidate.isLiteral()) continue;
            Literal literal = (Literal)candidate.as(Literal.class);
            if (lang == null || lang.equals(literal.getLanguage())) {
                return literal.getString();
            }
            aLiteral = literal.getString();
        }
        return aLiteral;
    }

    public class Value
    implements Comparable<Value> {
        private final RDFNode node;
        private URIPrefixer prefixer;

        public Value(RDFNode valueNode) {
            this.node = valueNode;
            if (valueNode.isURIResource()) {
                this.prefixer = new URIPrefixer((Resource)valueNode.as(Resource.class), ResourceDescription.this.getPrefixes());
            }
        }

        public Node getNode() {
            return this.node.asNode();
        }

        public boolean hasPrefix() {
            return this.prefixer != null && this.prefixer.hasPrefix();
        }

        public String getPrefix() {
            if (this.prefixer == null) {
                return null;
            }
            return this.prefixer.getPrefix();
        }

        public String getLocalName() {
            if (this.prefixer == null) {
                return null;
            }
            return this.prefixer.getLocalName();
        }

        public String getDatatypeLabel() {
            if (!this.node.isLiteral()) {
                return null;
            }
            String uri = ((Literal)this.node.as(Literal.class)).getDatatypeURI();
            if (uri == null) {
                return null;
            }
            URIPrefixer datatypePrefixer = new URIPrefixer(uri, ResourceDescription.this.getPrefixes());
            if (datatypePrefixer.hasPrefix()) {
                return datatypePrefixer.toTurtle();
            }
            return "?:" + datatypePrefixer.getLocalName();
        }

        @Override
        public int compareTo(Value other) {
            if (!(other instanceof Value)) {
                return 0;
            }
            Value otherValue = other;
            if (this.getNode().isURI() && otherValue.getNode().isURI()) {
                return this.getNode().getURI().compareTo(otherValue.getNode().getURI());
            }
            if (this.getNode().isURI()) {
                return 1;
            }
            if (otherValue.getNode().isURI()) {
                return -1;
            }
            if (this.getNode().isBlank() && otherValue.getNode().isBlank()) {
                return this.getNode().getBlankNodeLabel().compareTo(otherValue.getNode().getBlankNodeLabel());
            }
            if (this.getNode().isBlank()) {
                return 1;
            }
            if (otherValue.getNode().isBlank()) {
                return -1;
            }
            return this.getNode().getLiteralLexicalForm().compareTo(otherValue.getNode().getLiteralLexicalForm());
        }
    }

    private class PropertyBuilder {
        private final Property predicate;
        private final boolean isInverse;
        private final List<Value> values = new ArrayList<Value>();
        private int blankNodeCount = 0;

        PropertyBuilder(Property predicate, boolean isInverse) {
            this.predicate = predicate;
            this.isInverse = isInverse;
        }

        void addValue(RDFNode valueNode) {
            if (valueNode.isAnon()) {
                ++this.blankNodeCount;
                return;
            }
            this.values.add(new Value(valueNode));
        }

        ResourceProperty toProperty() {
            Collections.sort(this.values);
            return new ResourceProperty(this.predicate, this.isInverse, this.values, this.blankNodeCount);
        }
    }

    public class ResourceProperty
    implements Comparable<ResourceProperty> {
        private final Property predicate;
        private final URIPrefixer predicatePrefixer;
        private final boolean isInverse;
        private final List<Value> values;
        private final int blankNodeCount;

        public ResourceProperty(Property predicate, boolean isInverse, List<Value> values, int blankNodeCount) {
            this.predicate = predicate;
            this.predicatePrefixer = new URIPrefixer((Resource)predicate, ResourceDescription.this.getPrefixes());
            this.isInverse = isInverse;
            this.values = values;
            this.blankNodeCount = blankNodeCount;
        }

        public boolean isInverse() {
            return this.isInverse;
        }

        public String getURI() {
            return this.predicate.getURI();
        }

        public boolean hasPrefix() {
            return this.predicatePrefixer.hasPrefix();
        }

        public String getPrefix() {
            return this.predicatePrefixer.getPrefix();
        }

        public String getLocalName() {
            return this.predicatePrefixer.getLocalName();
        }

        public List<Value> getValues() {
            return this.values;
        }

        public int getBlankNodeCount() {
            return this.blankNodeCount;
        }

        public String getPathPageURL() {
            if (ResourceDescription.this.hypermediaResource == null) {
                return null;
            }
            return this.isInverse ? ResourceDescription.this.hypermediaResource.getInversePathPageURL(this.predicate) : ResourceDescription.this.hypermediaResource.getPathPageURL(this.predicate);
        }

        @Override
        public int compareTo(ResourceProperty other) {
            String otherLocalName;
            if (!(other instanceof ResourceProperty)) {
                return 0;
            }
            ResourceProperty otherProperty = other;
            String propertyLocalName = this.getLocalName();
            if (propertyLocalName.compareTo(otherLocalName = otherProperty.getLocalName()) != 0) {
                return propertyLocalName.compareTo(otherLocalName);
            }
            if (this.isInverse() != otherProperty.isInverse()) {
                return this.isInverse() ? -1 : 1;
            }
            return 0;
        }
    }
}

