/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import de.fuberlin.wiwiss.pubby.DataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;

public class RemoteSPARQLDataSource
implements DataSource {
    private final String endpointURL;
    private final String defaultGraphName;
    private String previousDescribeQuery;
    private String contentType = null;

    public RemoteSPARQLDataSource(String endpointURL, String graphName) {
        this.endpointURL = endpointURL;
        this.defaultGraphName = graphName;
    }

    public void setContentType(String mediaType) {
        this.contentType = mediaType;
    }

    @Override
    public String getEndpointURL() {
        return this.endpointURL;
    }

    private String buildDescribeQuery(String resourceURI) {
        return "DESCRIBE <" + resourceURI + ">";
    }

    @Override
    public Model getResourceDescription(String resourceURI) {
        return this.execDescribeQuery(this.buildDescribeQuery(resourceURI));
    }

    @Override
    public Model getAnonymousPropertyValues(String resourceURI, Property property, boolean isInverse) {
        String query = "DESCRIBE ?x WHERE { " + (isInverse ? "?x <" + property.getURI() + "> <" + resourceURI + "> . " : "<" + resourceURI + "> <" + property.getURI() + "> ?x . ") + "FILTER (isBlank(?x)) }";
        return this.execDescribeQuery(query);
    }

    @Override
    public List<Resource> getIndex() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        ResultSet rs = this.execSelectQuery("SELECT DISTINCT ?s { ?s ?p ?o FILTER (isURI(?s)) } LIMIT 1000");
        while (rs.hasNext()) {
            result.add(rs.next().getResource("s"));
        }
        return result;
    }

    public String getPreviousDescribeQuery() {
        return this.previousDescribeQuery;
    }

    private Model execDescribeQuery(String query) {
        this.previousDescribeQuery = query;
        QueryEngineHTTP endpoint = new QueryEngineHTTP(this.endpointURL, query);
        if (this.defaultGraphName != null) {
            endpoint.setDefaultGraphURIs(Collections.singletonList(this.defaultGraphName));
        }
        if (this.contentType != null) {
            endpoint.setModelContentType(this.contentType);
        }
        return endpoint.execDescribe();
    }

    private ResultSet execSelectQuery(String query) {
        QueryEngineHTTP endpoint = new QueryEngineHTTP(this.endpointURL, query);
        if (this.defaultGraphName != null) {
            endpoint.setDefaultGraphURIs(Collections.singletonList(this.defaultGraphName));
        }
        return endpoint.execSelect();
    }
}

