/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.Dataset;
import de.fuberlin.wiwiss.pubby.MappedResource;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;

public class ModelTranslator {
    private final Model model;
    private final Dataset dataset;
    private final Configuration serverConfig;

    public ModelTranslator(Model model, Dataset dataset, Configuration configuration) {
        this.model = model;
        this.dataset = dataset;
        this.serverConfig = configuration;
    }

    public Model getTranslated() {
        Model result = ModelFactory.createDefaultModel();
        result.setNsPrefixes((PrefixMapping)this.model);
        for (String prefix : this.serverConfig.getPrefixes().getNsPrefixMap().keySet()) {
            result.setNsPrefix(prefix, this.serverConfig.getPrefixes().getNsPrefixURI(prefix));
        }
        StmtIterator it = this.model.listStatements();
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            Resource s = stmt.getSubject();
            if (s.isURIResource()) {
                s = result.createResource(this.getPublicURI(s.getURI()));
            }
            Property p = result.createProperty(this.getPublicURI(stmt.getPredicate().getURI()));
            RDFNode o = stmt.getObject();
            if (o.isURIResource()) {
                o = result.createResource(this.getPublicURI(((Resource)o).getURI()));
            }
            result.add(s, p, o);
        }
        return result;
    }

    private String getPublicURI(String datasetURI) {
        MappedResource resource = this.dataset.getMappedResourceFromDatasetURI(datasetURI, this.serverConfig);
        if (resource == null) {
            return datasetURI;
        }
        return resource.getController().getAbsoluteIRI();
    }
}

