/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import de.fuberlin.wiwiss.pubby.negotiation.ContentTypeNegotiator;
import de.fuberlin.wiwiss.pubby.negotiation.MediaRangeSpec;
import de.fuberlin.wiwiss.pubby.negotiation.PubbyNegotiator;
import de.fuberlin.wiwiss.pubby.servlets.RequestParamHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFWriter;
import org.apache.jena.shared.JenaException;

public class ModelResponse {
    private final Model model;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public ModelResponse(Model model, HttpServletRequest request, HttpServletResponse response) {
        RequestParamHandler handler = new RequestParamHandler(request);
        if (handler.isMatchingRequest()) {
            request = handler.getModifiedRequest();
        }
        this.model = model;
        this.request = request;
        this.response = response;
    }

    public void serve() {
        try {
            this.doResponseModel();
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
        catch (JenaException jEx) {
            try {
                this.response.sendError(500, "JenaException: " + jEx.getMessage());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void doResponseModel() throws IOException {
        this.response.addHeader("Vary", "Accept");
        ContentTypeNegotiator negotiator = PubbyNegotiator.getDataNegotiator();
        MediaRangeSpec bestMatch = negotiator.getBestMatch(this.request.getHeader("Accept"), this.request.getHeader("User-Agent"));
        if (bestMatch == null) {
            this.response.setStatus(406);
            this.response.setContentType("text/plain");
            ServletOutputStream out = this.response.getOutputStream();
            out.println("406 Not Acceptable: The requested data format is not supported.");
            out.println("Supported formats are RDF/XML, Turtle, N3, and N-Triples.");
            return;
        }
        this.response.setContentType(bestMatch.getMediaType());
        this.getWriter(bestMatch.getMediaType()).write(this.model, this.response);
        this.response.getOutputStream().flush();
    }

    private ModelWriter getWriter(String mediaType) {
        if ("application/rdf+xml".equals(mediaType)) {
            return new RDFXMLWriter();
        }
        if ("application/x-turtle".equals(mediaType)) {
            return new TurtleWriter();
        }
        if ("text/rdf+n3;charset=utf-8".equals(mediaType)) {
            return new TurtleWriter();
        }
        return new NTriplesWriter();
    }

    private class RDFXMLWriter
    implements ModelWriter {
        private RDFXMLWriter() {
        }

        @Override
        public void write(Model model, HttpServletResponse response) throws IOException {
            RDFWriter writer = model.getWriter("RDF/XML-ABBREV");
            writer.setProperty("showXmlDeclaration", (Object)"true");
            writer.setProperty("blockRules", (Object)"propertyAttr");
            writer.write(model, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8"), null);
        }
    }

    private class TurtleWriter
    implements ModelWriter {
        private TurtleWriter() {
        }

        @Override
        public void write(Model model, HttpServletResponse response) throws IOException {
            model.getWriter("TURTLE").write(model, (OutputStream)response.getOutputStream(), null);
        }
    }

    private class NTriplesWriter
    implements ModelWriter {
        private NTriplesWriter() {
        }

        @Override
        public void write(Model model, HttpServletResponse response) throws IOException {
            model.getWriter("N-TRIPLES").write(model, (OutputStream)response.getOutputStream(), null);
        }
    }

    private static interface ModelWriter {
        public void write(Model var1, HttpServletResponse var2) throws IOException;
    }
}

