/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import de.fuberlin.wiwiss.pubby.DataSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;

public class ModelDataSource
implements DataSource {
    private Model model;

    public ModelDataSource(Model model) {
        this.model = model;
    }

    @Override
    public String getEndpointURL() {
        return null;
    }

    @Override
    public Model getResourceDescription(String resourceURI) {
        Model result = ModelFactory.createDefaultModel();
        result.setNsPrefixes((PrefixMapping)this.model);
        this.addResourceDescription(this.model.getResource(resourceURI), result);
        return result;
    }

    @Override
    public Model getAnonymousPropertyValues(String resourceURI, Property property, boolean isInverse) {
        StmtIterator it;
        Resource r = this.model.getResource(resourceURI);
        Model result = ModelFactory.createDefaultModel();
        result.setNsPrefixes((PrefixMapping)this.model);
        StmtIterator stmtIterator = it = isInverse ? this.model.listStatements(null, property, (RDFNode)r) : r.listProperties(property);
        while (it.hasNext()) {
            Resource node;
            Statement stmt = it.nextStatement();
            Object object = node = isInverse ? stmt.getSubject() : stmt.getObject();
            if (!node.isAnon()) continue;
            this.addResourceDescription((Resource)node.as(Resource.class), result);
        }
        return result;
    }

    @Override
    public List<Resource> getIndex() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        ResIterator it = this.model.listSubjects();
        while (it.hasNext()) {
            result.add((Resource)it.next());
            if (result.size() < 1000) continue;
            break;
        }
        return result;
    }

    private void addResourceDescription(Resource resource, Model targetModel) {
        targetModel.add(this.model.listStatements(resource, null, (RDFNode)null));
        targetModel.add(this.model.listStatements(null, null, (RDFNode)resource));
    }
}

