/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.DataSource;
import de.fuberlin.wiwiss.pubby.Dataset;
import de.fuberlin.wiwiss.pubby.HypermediaResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDFS;

public class IndexDataSource
implements DataSource {
    private static final String INDEX_TITLE = "Index of Resources";
    private static final Model EMPTY_MODEL = ModelFactory.createDefaultModel();
    private final String indexURL;
    private final Collection<Dataset> datasets;
    private final Configuration config;
    private static final String SIOC_NS = "http://rdfs.org/sioc/ns#";
    private static final Property siocContainerOf = ResourceFactory.createProperty((String)"http://rdfs.org/sioc/ns#container_of");

    public IndexDataSource(String indexURL, Collection<Dataset> datasets, Configuration config) {
        this.indexURL = indexURL;
        this.datasets = datasets;
        this.config = config;
    }

    @Override
    public String getEndpointURL() {
        return null;
    }

    @Override
    public Model getResourceDescription(String resourceURI) {
        if (!this.indexURL.equals(resourceURI)) {
            return EMPTY_MODEL;
        }
        ArrayList<HypermediaResource> resources = new ArrayList<HypermediaResource>();
        for (Dataset dataset : this.datasets) {
            resources.addAll(dataset.getIndex(this.config));
        }
        return this.describe(resources);
    }

    @Override
    public Model getAnonymousPropertyValues(String resourceURI, Property property, boolean isInverse) {
        return EMPTY_MODEL;
    }

    @Override
    public List<Resource> getIndex() {
        return Collections.singletonList(ResourceFactory.createResource((String)this.indexURL));
    }

    private Model describe(List<HypermediaResource> resources) {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("sioc", SIOC_NS);
        model.setNsPrefix("rdfs", RDFS.getURI());
        model.setNsPrefixes(this.config.getPrefixes());
        Resource index = model.createResource(this.config.getWebApplicationBaseURI());
        for (HypermediaResource resource : resources) {
            Resource r = model.createResource(resource.getAbsoluteIRI());
            if (index.equals((Object)r)) continue;
            index.addProperty(siocContainerOf, (RDFNode)r);
        }
        index.addProperty(RDFS.label, INDEX_TITLE);
        return model;
    }
}

