/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.DataSource;
import de.fuberlin.wiwiss.pubby.DataSourceRegistry;
import de.fuberlin.wiwiss.pubby.HypermediaResource;
import de.fuberlin.wiwiss.pubby.IRIEncoder;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.ModelDataSource;
import de.fuberlin.wiwiss.pubby.RemoteSPARQLDataSource;
import de.fuberlin.wiwiss.pubby.vocab.CONF;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.FileUtils;
import org.apache.jena.vocabulary.XSD;

public class Dataset {
    private static final String metadataPlaceholderURIPrefix = "about:metadata:";
    private final Model model;
    private final Resource config;
    private final DataSource dataSource;
    private final String datasetBase;
    private final Pattern datasetURIPattern;
    private final char[] fixUnescapeCharacters;
    private final Resource rdfDocumentMetadataTemplate;
    private final String metadataTemplate;
    private Calendar currentTime;
    private Resource currentDocRepr;

    public Dataset(DataSource dataSource, String constantURI) {
        this.dataSource = dataSource;
        this.model = ModelFactory.createDefaultModel();
        this.config = this.model.createResource();
        this.datasetBase = constantURI;
        this.datasetURIPattern = Pattern.compile("^$");
        this.fixUnescapeCharacters = new char[0];
        this.rdfDocumentMetadataTemplate = null;
        this.metadataTemplate = null;
    }

    public Dataset(Resource config) {
        this.config = config;
        this.model = config.getModel();
        this.datasetBase = config.getProperty(CONF.datasetBase).getResource().getURI();
        this.datasetURIPattern = config.hasProperty(CONF.datasetURIPattern) ? Pattern.compile(config.getProperty(CONF.datasetURIPattern).getString()) : Pattern.compile(".*");
        if (config.hasProperty(CONF.fixUnescapedCharacters)) {
            String chars = config.getProperty(CONF.fixUnescapedCharacters).getString();
            this.fixUnescapeCharacters = new char[chars.length()];
            for (int i = 0; i < chars.length(); ++i) {
                this.fixUnescapeCharacters[i] = chars.charAt(i);
            }
        } else {
            this.fixUnescapeCharacters = new char[0];
        }
        this.rdfDocumentMetadataTemplate = config.hasProperty(CONF.rdfDocumentMetadata) ? config.getProperty(CONF.rdfDocumentMetadata).getResource() : null;
        this.metadataTemplate = config.hasProperty(CONF.metadataTemplate) ? config.getProperty(CONF.metadataTemplate).getString() : null;
        if (config.hasProperty(CONF.sparqlEndpoint)) {
            String endpointURL = config.getProperty(CONF.sparqlEndpoint).getResource().getURI();
            String defaultGraph = config.hasProperty(CONF.sparqlDefaultGraph) ? config.getProperty(CONF.sparqlDefaultGraph).getResource().getURI() : null;
            DataSource tmpDataSource = DataSourceRegistry.getInstance().get(endpointURL);
            if (tmpDataSource == null) {
                tmpDataSource = new RemoteSPARQLDataSource(endpointURL, defaultGraph);
            }
            this.dataSource = tmpDataSource;
        } else {
            Model data = ModelFactory.createDefaultModel();
            StmtIterator it = config.listProperties(CONF.loadRDF);
            while (it.hasNext()) {
                Statement stmt = it.nextStatement();
                FileManager.get().readModel(data, stmt.getResource().getURI());
            }
            this.dataSource = new ModelDataSource(data);
        }
    }

    public boolean isDatasetURI(String uri) {
        return uri.startsWith(this.getDatasetBase()) && this.datasetURIPattern.matcher(uri.substring(this.getDatasetBase().length())).matches();
    }

    public MappedResource getMappedResourceFromDatasetURI(String datasetURI, Configuration configuration) {
        if (!this.isDatasetURI(datasetURI)) {
            return null;
        }
        return new MappedResource(this.escapeURIDelimiters(datasetURI.substring(this.getDatasetBase().length())), datasetURI, configuration, this);
    }

    public MappedResource getMappedResourceFromRelativeWebURI(String relativeWebURI, boolean isResourceURI, Configuration configuration) {
        if (isResourceURI && !"".equals(configuration.getWebResourcePrefix())) {
            if (!relativeWebURI.startsWith(configuration.getWebResourcePrefix())) {
                return null;
            }
            relativeWebURI = relativeWebURI.substring(configuration.getWebResourcePrefix().length());
        }
        if (!this.datasetURIPattern.matcher(relativeWebURI = this.fixUnescapedCharacters(relativeWebURI)).matches()) {
            return null;
        }
        String decoded = this.getSupportsIRIs() ? IRIEncoder.toIRI(relativeWebURI) : relativeWebURI;
        return new MappedResource(decoded, this.getDatasetBase() + this.unescapeURIDelimiters(decoded), configuration, this);
    }

    public boolean getSupportsIRIs() {
        return this.getBooleanConfigValue(CONF.supportsIRIs, true);
    }

    private String getDatasetBase() {
        return this.datasetBase;
    }

    public boolean getAddSameAsStatements() {
        return this.getBooleanConfigValue(CONF.addSameAsStatements, false);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public List<HypermediaResource> getIndex(Configuration configuration) {
        ArrayList<HypermediaResource> result = new ArrayList<HypermediaResource>();
        for (Resource r : this.dataSource.getIndex()) {
            if (!r.getURI().startsWith(this.datasetBase)) continue;
            result.add(this.getMappedResourceFromDatasetURI(r.getURI(), configuration).getController());
        }
        return result;
    }

    public void addDocumentMetadata(Model document, Resource documentResource) {
        Statement stmt;
        if (this.rdfDocumentMetadataTemplate == null) {
            return;
        }
        StmtIterator it = this.rdfDocumentMetadataTemplate.listProperties();
        while (it.hasNext()) {
            stmt = it.nextStatement();
            document.add(documentResource, stmt.getPredicate(), stmt.getObject());
        }
        it = this.model.listStatements(null, null, (RDFNode)this.rdfDocumentMetadataTemplate);
        while (it.hasNext()) {
            stmt = it.nextStatement();
            if (stmt.getPredicate().equals(CONF.rdfDocumentMetadata)) continue;
            document.add(stmt.getSubject(), stmt.getPredicate(), (RDFNode)documentResource);
        }
    }

    public Resource addMetadataFromTemplate(Model document, MappedResource describedResource, ServletContext context) {
        if (this.metadataTemplate == null) {
            return null;
        }
        this.currentTime = Calendar.getInstance();
        Model tplModel = ModelFactory.createDefaultModel();
        String tplPath = context.getRealPath("/") + "/WEB-INF/templates/" + this.metadataTemplate;
        FileManager.get().readModel(tplModel, tplPath, FileUtils.guessLang((String)tplPath, (String)"N3"));
        Model metadata = ModelFactory.createDefaultModel();
        this.currentDocRepr = metadata.createResource();
        StmtIterator it = tplModel.listStatements();
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            Resource subj = stmt.getSubject();
            Property pred = stmt.getPredicate();
            RDFNode obj = stmt.getObject();
            try {
                if (subj.toString().contains(metadataPlaceholderURIPrefix) && (subj = (Resource)this.parsePlaceholder((RDFNode)subj, describedResource, context)) == null) {
                    subj = this.model.createResource(new AnonId(String.valueOf(stmt.getSubject().hashCode())));
                }
                if (obj.toString().contains(metadataPlaceholderURIPrefix)) {
                    obj = this.parsePlaceholder(obj, describedResource, context);
                }
                if (obj == null) continue;
                stmt = metadata.createStatement(subj, pred, obj);
                metadata.add(stmt);
            }
            catch (Exception e) {
                metadata.remove(stmt);
                e.printStackTrace();
            }
        }
        boolean changes = true;
        while (changes) {
            changes = false;
            StmtIterator stmtIt = metadata.listStatements();
            ArrayList<Statement> remList = new ArrayList<Statement>();
            while (stmtIt.hasNext()) {
                Statement s = stmtIt.nextStatement();
                if (!s.getObject().isAnon() || ((Resource)s.getObject().as(Resource.class)).listProperties().hasNext()) continue;
                remList.add(s);
                changes = true;
            }
            metadata.remove(remList);
        }
        if (document != null) {
            document.add(metadata);
        }
        return this.currentDocRepr;
    }

    private RDFNode parsePlaceholder(RDFNode phRes, MappedResource describedResource, ServletContext context) {
        Resource globalConfig;
        Statement ptrStmt;
        StmtIterator it;
        Property p;
        String phURI = phRes.asNode().getURI();
        phURI = phURI.replace(metadataPlaceholderURIPrefix, "");
        String phPackage = phURI.substring(0, phURI.indexOf(":") + 1);
        String phName = phURI.replace(phPackage, "");
        if ((phPackage = phPackage.replace(":", "")).equals("runtime")) {
            if (phName.equals("query")) {
                RemoteSPARQLDataSource ds = (RemoteSPARQLDataSource)describedResource.getDataset().getDataSource();
                return this.model.createTypedLiteral(ds.getPreviousDescribeQuery());
            }
            if (phName.equals("time")) {
                return this.model.createTypedLiteral(this.currentTime);
            }
            if (phName.equals("graph")) {
                return this.currentDocRepr;
            }
            if (phName.equals("data")) {
                return this.model.createResource(describedResource.getController().getDataURL());
            }
            if (phName.equals("resource")) {
                return this.model.createResource(describedResource.getController().getAbsoluteIRI());
            }
        }
        if (phPackage.equals("config")) {
            p = this.model.createProperty("http://richard.cyganiak.de/2007/pubby/config.rdf#" + phName);
            if (this.config.hasProperty(p)) {
                return this.config.getProperty(p).getObject();
            }
            it = this.config.getModel().listStatements(null, CONF.dataset, (RDFNode)this.config);
            ptrStmt = it.nextStatement();
            if (ptrStmt == null) {
                return null;
            }
            globalConfig = ptrStmt.getSubject();
            if (globalConfig.hasProperty(p)) {
                return globalConfig.getProperty(p).getObject();
            }
        }
        if (phPackage.equals("metadata")) {
            p = this.model.createProperty("http://example.org/metadata#" + phName);
            if (this.config.hasProperty(p)) {
                return this.config.getProperty(p).getObject();
            }
            it = this.config.getModel().listStatements(null, CONF.dataset, (RDFNode)this.config);
            ptrStmt = it.nextStatement();
            if (ptrStmt == null) {
                return null;
            }
            globalConfig = ptrStmt.getSubject();
            if (globalConfig.hasProperty(p)) {
                return globalConfig.getProperty(p).getObject();
            }
        }
        return this.model.createResource(new AnonId(String.valueOf(phRes.hashCode())));
    }

    private boolean getBooleanConfigValue(Property property, boolean defaultValue) {
        if (!this.config.hasProperty(property)) {
            return defaultValue;
        }
        Literal value = this.config.getProperty(property).getLiteral();
        if (XSD.xboolean.equals((Object)value.getDatatype())) {
            return value.getBoolean();
        }
        return "true".equals(value.getString());
    }

    private String fixUnescapedCharacters(String uri) {
        if (this.fixUnescapeCharacters.length == 0) {
            return uri;
        }
        StringBuffer encoded = new StringBuffer(uri.length() + 4);
        for (int charIndex = 0; charIndex < uri.length(); ++charIndex) {
            boolean encodeThis = false;
            if (uri.charAt(charIndex) > '\u007f') {
                encodeThis = true;
            }
            for (int i = 0; i < this.fixUnescapeCharacters.length; ++i) {
                if (uri.charAt(charIndex) != this.fixUnescapeCharacters[i]) continue;
                encodeThis = true;
                break;
            }
            if (encodeThis) {
                encoded.append('%');
                char b = uri.charAt(charIndex);
                encoded.append(Integer.toString(b, 16).toUpperCase());
                continue;
            }
            encoded.append(uri.charAt(charIndex));
        }
        return encoded.toString();
    }

    private String escapeURIDelimiters(String uri) {
        return uri.replaceAll("#", "%23").replaceAll("\\?", "%3F");
    }

    private String unescapeURIDelimiters(String uri) {
        return uri.replaceAll("%23", "#").replaceAll("%3F", "?");
    }
}

