/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import de.fuberlin.wiwiss.pubby.Dataset;
import de.fuberlin.wiwiss.pubby.HypermediaResource;
import de.fuberlin.wiwiss.pubby.IndexDataSource;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.ModelUtil;
import de.fuberlin.wiwiss.pubby.vocab.CONF;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.util.FileManager;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class Configuration {
    private static final String DEFAULT_PROJECT_NAME = "Untitled Dataset";
    private final Model model;
    private final Resource config;
    private final PrefixMapping prefixes;
    private final Collection<Property> labelProperties;
    private final Collection<Property> commentProperties;
    private final Collection<Property> imageProperties;
    private final ArrayList<Dataset> datasets = new ArrayList();

    public Configuration(Model configurationModel) {
        this.model = configurationModel;
        StmtIterator it = this.model.listStatements(null, RDF.type, (RDFNode)CONF.Configuration);
        if (!it.hasNext()) {
            throw new IllegalArgumentException("No conf:Configuration found in configuration model");
        }
        this.config = it.nextStatement().getSubject();
        it = this.model.listStatements(this.config, CONF.dataset, (RDFNode)null);
        while (it.hasNext()) {
            this.datasets.add(new Dataset(it.nextStatement().getResource()));
        }
        this.labelProperties = new ArrayList<Property>();
        it = this.model.listStatements(this.config, CONF.labelProperty, (RDFNode)null);
        while (it.hasNext()) {
            this.labelProperties.add((Property)it.nextStatement().getObject().as(Property.class));
        }
        if (this.labelProperties.isEmpty()) {
            this.labelProperties.add(RDFS.label);
            this.labelProperties.add(DC.title);
            this.labelProperties.add(this.model.createProperty("http://xmlns.com/foaf/0.1/name"));
        }
        this.commentProperties = new ArrayList<Property>();
        it = this.model.listStatements(this.config, CONF.commentProperty, (RDFNode)null);
        while (it.hasNext()) {
            this.commentProperties.add((Property)it.nextStatement().getObject().as(Property.class));
        }
        if (this.commentProperties.isEmpty()) {
            this.commentProperties.add(RDFS.comment);
            this.commentProperties.add(DC.description);
        }
        this.imageProperties = new ArrayList<Property>();
        it = this.model.listStatements(this.config, CONF.imageProperty, (RDFNode)null);
        while (it.hasNext()) {
            this.imageProperties.add((Property)it.nextStatement().getObject().as(Property.class));
        }
        if (this.imageProperties.isEmpty()) {
            this.imageProperties.add(this.model.createProperty("http://xmlns.com/foaf/0.1/depiction"));
        }
        this.prefixes = new PrefixMappingImpl();
        if (this.config.hasProperty(CONF.usePrefixesFrom)) {
            it = this.config.listProperties(CONF.usePrefixesFrom);
            while (it.hasNext()) {
                Statement stmt = it.nextStatement();
                String uri = stmt.getResource().getURI();
                this.prefixes.setNsPrefixes((PrefixMapping)FileManager.get().loadModel(uri));
            }
        } else {
            this.prefixes.setNsPrefixes((PrefixMapping)this.model);
        }
        if (this.prefixes.getNsURIPrefix("http://richard.cyganiak.de/2007/pubby/config.rdf#") != null) {
            this.prefixes.removeNsPrefix(this.prefixes.getNsURIPrefix("http://richard.cyganiak.de/2007/pubby/config.rdf#"));
        }
        ModelUtil.addNSIfUndefined(this.prefixes, "rdf", RDF.getURI());
        ModelUtil.addNSIfUndefined(this.prefixes, "xsd", XSD.getURI());
        if (!this.config.hasProperty(CONF.indexResource)) {
            String indexURL = this.getWebApplicationBaseURI();
            ArrayList<Dataset> realDatasets = new ArrayList<Dataset>(this.datasets);
            Dataset indexDataset = new Dataset(new IndexDataSource(indexURL, realDatasets, this), indexURL);
            this.datasets.add(0, indexDataset);
        }
    }

    public HypermediaResource getController(String relativeIRI, boolean stripResourcePrefix) {
        if (stripResourcePrefix) {
            if (!relativeIRI.startsWith(this.getWebResourcePrefix())) {
                return null;
            }
            relativeIRI = relativeIRI.substring(this.getWebResourcePrefix().length());
        }
        return new HypermediaResource(relativeIRI, this);
    }

    public Collection<MappedResource> getMappedResourcesFromRelativeWebURI(String relativeWebURI, boolean isResourceURI) {
        ArrayList<MappedResource> results = new ArrayList<MappedResource>();
        for (Dataset dataset : this.datasets) {
            MappedResource resource = dataset.getMappedResourceFromRelativeWebURI(relativeWebURI, isResourceURI, this);
            if (resource == null) continue;
            results.add(resource);
        }
        return results;
    }

    public PrefixMapping getPrefixes() {
        return this.prefixes;
    }

    public Collection<Property> getLabelProperties() {
        return this.labelProperties;
    }

    public Collection<Property> getCommentProperties() {
        return this.commentProperties;
    }

    public Collection<Property> getImageProperties() {
        return this.imageProperties;
    }

    public String getDefaultLanguage() {
        if (!this.config.hasProperty(CONF.defaultLanguage)) {
            return null;
        }
        return this.config.getProperty(CONF.defaultLanguage).getString();
    }

    public HypermediaResource getIndexResource() {
        String resourceBase;
        if (!this.config.hasProperty(CONF.indexResource)) {
            return null;
        }
        String uri = this.config.getProperty(CONF.indexResource).getResource().getURI();
        if (!uri.startsWith(resourceBase = this.getWebApplicationBaseURI() + this.getWebResourcePrefix())) {
            throw new RuntimeException("conf:indexResource must start with " + resourceBase);
        }
        return new HypermediaResource(uri.substring(resourceBase.length()), this);
    }

    public String getProjectLink() {
        Statement stmt = this.config.getProperty(CONF.projectHomepage);
        return stmt == null ? null : stmt.getResource().getURI();
    }

    public String getProjectName() {
        Statement stmt = this.config.getProperty(CONF.projectName);
        return stmt == null ? DEFAULT_PROJECT_NAME : stmt.getString();
    }

    public String getWebApplicationBaseURI() {
        return this.config.getProperty(CONF.webBase).getResource().getURI();
    }

    public String getWebResourcePrefix() {
        if (this.config.hasProperty(CONF.webResourcePrefix)) {
            return this.config.getProperty(CONF.webResourcePrefix).getString();
        }
        return "";
    }
}

