/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.seeds;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.coyotecache.seeds.SeedOrderInterface;
import org.apache.log4j.Logger;

public abstract class SeedOrder
implements SeedOrderInterface {
    public static Logger log4j = Logger.getLogger(SeedOrder.class);
    protected Set<Integer> m_seeds = new LinkedHashSet<Integer>();
    protected Set<Integer> m_blackList = new TreeSet<Integer>();
    protected Set<Integer> m_nextSeeds = null;

    public SeedOrder() {
        log4j.info((Object)("starting " + this.getClass().getSimpleName() + "..."));
    }

    @Override
    public boolean addAll(Set<Integer> seeds) {
        if (seeds == null) {
            throw new NullPointerException("parameter is null.");
        }
        if (seeds.isEmpty()) {
            log4j.warn((Object)"parameter is empty.");
        }
        LinkedHashSet<Integer> tmpSeeds = new LinkedHashSet<Integer>(seeds);
        tmpSeeds.removeAll(this.m_blackList);
        if (this.m_nextSeeds != null) {
            tmpSeeds.removeAll(this.m_nextSeeds);
        }
        return this.m_seeds.addAll(tmpSeeds);
    }

    @Override
    public boolean add(int seed) {
        if (!this.m_seeds.contains(seed) && !this.m_blackList.contains(seed)) {
            if (this.m_nextSeeds != null) {
                if (!this.m_nextSeeds.contains(seed)) {
                    return this.m_seeds.add(seed);
                }
            } else {
                return this.m_seeds.add(seed);
            }
        }
        return false;
    }

    @Override
    public Integer getBestSeed() {
        Integer removed = null;
        if (this.m_nextSeeds != null && !this.m_nextSeeds.isEmpty()) {
            removed = this.m_nextSeeds.iterator().next();
            this.m_nextSeeds.remove(removed);
            this.m_blackList.add(removed);
        } else if (!this.m_seeds.isEmpty()) {
            removed = this.m_seeds.iterator().next();
            this.m_seeds.remove(removed);
            this.m_blackList.add(removed);
        }
        return removed;
    }

    @Override
    public Set<Integer> getUnusedSeeds(Set<Integer> nodes) {
        if (!nodes.isEmpty()) {
            LinkedHashSet<Integer> unused = new LinkedHashSet<Integer>(nodes);
            unused.removeAll(this.m_blackList);
            LinkedHashSet<Integer> future = new LinkedHashSet<Integer>();
            if (this.m_nextSeeds != null) {
                future.addAll(this.m_nextSeeds);
            }
            future.addAll(this.m_seeds);
            unused.retainAll(future);
            return unused;
        }
        log4j.warn((Object)"parameter is empty.");
        return new LinkedHashSet<Integer>();
    }

    @Override
    public boolean hasUnusedSeeds(Set<Integer> nodes) {
        if (!nodes.isEmpty()) {
            for (Integer i : nodes) {
                if (!this.m_seeds.contains(i) && (this.m_nextSeeds == null || !this.m_nextSeeds.contains(i))) continue;
                return true;
            }
        } else {
            log4j.warn((Object)"parameter is empty.");
        }
        return false;
    }

    @Override
    public boolean update(Set<Integer> cluster) {
        return false;
    }

    public String toString() {
        String rtn = "blackList: " + this.m_blackList.toString() + "\nseeds: " + this.m_seeds.toString();
        if (this.m_nextSeeds != null) {
            rtn = rtn + "\nnextSeeds: " + this.m_nextSeeds.toString();
        }
        return rtn;
    }

    @Override
    public void clear() {
        this.m_seeds.clear();
        this.m_blackList.clear();
        if (this.m_nextSeeds != null) {
            this.m_nextSeeds.clear();
        }
    }
}

