/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.coyotecache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.aksw.coyotecache.cache.CacheInterface;
import org.aksw.coyotecache.cache.Element;
import org.aksw.coyotecache.coyotecache.CoyoteCacheInterface;
import org.aksw.coyotecache.coyotecache.Statistic;
import org.aksw.coyotecache.seeds.SeedOrderInterface;
import org.apache.log4j.Logger;

public class CoyoteCache
implements CoyoteCacheInterface {
    public static final boolean online = false;
    public static Logger log4j = Logger.getLogger(CoyoteCache.class);
    public CacheInterface m_cache = null;
    protected SeedOrderInterface m_seedPolicy = null;
    protected List<Element> m_partialCluster = new ArrayList<Element>();
    private int maxSize;
    protected Map<Integer, Set<Integer>> m_finalCluster = new Hashtable<Integer, Set<Integer>>();
    private int m_id = 0;
    public Statistic m_statistic = new Statistic();

    public CoyoteCache(CacheInterface cache, SeedOrderInterface seedPolicy) {
        this.m_cache = cache;
        this.m_seedPolicy = seedPolicy;
        this.maxSize = this.m_cache.maxSize();
    }

    public CoyoteCache(CacheInterface cache) {
        this.m_cache = cache;
        this.maxSize = this.m_cache.maxSize();
    }

    @Override
    public Set<Integer> put(Set<Integer> finalSet) {
        this.putOffline(finalSet);
        this.updateFinalClusterMap();
        this.m_finalCluster.put(this.m_id, finalSet);
        this.m_statistic.setMaxLogSize(this.m_partialCluster.size());
        this.m_partialCluster.clear();
        ++this.m_id;
        return finalSet;
    }

    private void putOnline(Set<Integer> finalSet) {
        ListIterator<Element> i = this.m_partialCluster.listIterator(0);
        while (i.hasNext()) {
            Element element = i.next();
            if (this.m_seedPolicy != null) {
                this.m_seedPolicy.update((Set)element.getObject());
            }
            if (element.getObject().equals(finalSet)) continue;
            this.m_cache.put(element, this.m_id);
        }
    }

    private void putOffline(Set<Integer> finalSet) {
        ListIterator<Element> i = this.m_partialCluster.listIterator(0);
        while (i.hasNext()) {
            Element element = i.next();
            if (this.m_seedPolicy != null) {
                if (!this.m_seedPolicy.hasUnusedSeeds((Set)element.getObject())) break;
                this.m_seedPolicy.update((Set)element.getObject());
                if (element.getObject().equals(finalSet)) continue;
                this.m_cache.put(element, this.m_id);
                continue;
            }
            if (element.getObject().equals(finalSet)) continue;
            this.m_cache.put(element, this.m_id);
        }
    }

    private void updateFinalClusterMap() {
        if (this.m_finalCluster.size() >= this.maxSize) {
            Collection<Object> idsInCache = this.m_cache.values();
            Iterator<Map.Entry<Integer, Set<Integer>>> ii = this.m_finalCluster.entrySet().iterator();
            Integer smallestClusterId = null;
            Integer smallestClusterSize = null;
            while (ii.hasNext()) {
                Map.Entry<Integer, Set<Integer>> entry = ii.next();
                if (smallestClusterId == null || smallestClusterSize > entry.getValue().size()) {
                    smallestClusterId = entry.getKey();
                    smallestClusterSize = entry.getValue().size();
                }
                if (idsInCache.contains(entry.getKey())) continue;
                ii.remove();
            }
            if (this.m_finalCluster.size() >= this.maxSize && smallestClusterId != null) {
                this.m_finalCluster.remove(smallestClusterId);
                this.m_cache.removeValues(smallestClusterId);
            }
        }
    }

    @Override
    public Set<Integer> get(Set<Integer> element) {
        return this.get(element, 0.0);
    }

    @Override
    public Set<Integer> get(Set<Integer> set, Double cost) {
        if (set.size() < 2) {
            this.m_statistic.incDismissed();
            return null;
        }
        Integer id_final = null;
        for (Integer id : this.m_finalCluster.keySet()) {
            if (!this.m_finalCluster.get(id).equals(set)) continue;
            id_final = id;
            this.m_statistic.incDictionaryHits();
            break;
        }
        Element element = new Element(new LinkedHashSet<Integer>(set), cost);
        if (id_final == null) {
            id_final = (Integer)this.m_cache.get(element);
            if (id_final == null) {
                this.m_statistic.incFaults();
            } else {
                this.m_statistic.incHitCost(cost);
            }
        }
        if (id_final != null) {
            if (!this.m_partialCluster.isEmpty()) {
                for (Element logElement : this.m_partialCluster) {
                    if (this.m_seedPolicy != null) {
                        this.m_seedPolicy.update((Set)logElement.getObject());
                    }
                    if (this.m_finalCluster.containsValue(logElement.getObject())) continue;
                    this.m_cache.put(logElement, id_final);
                }
            }
            this.m_partialCluster.clear();
            return this.m_finalCluster.get(id_final);
        }
        this.addElementToLog(element);
        return null;
    }

    private boolean addElementToLog(Element element) {
        if (this.m_seedPolicy != null) {
            if (this.m_seedPolicy.hasUnusedSeeds((Set)element.getObject())) {
                return this.m_partialCluster.add(element);
            }
            return false;
        }
        return this.m_partialCluster.add(element);
    }

    public String toString() {
        return this.m_cache.getClass().getSimpleName() + "\t" + this.m_cache.maxSize();
    }

    @Override
    public Integer getBestSeed() {
        return this.m_seedPolicy.getBestSeed();
    }

    @Override
    public void setSeeds(Set<Integer> seeds) {
        if (this.m_seedPolicy != null) {
            this.m_seedPolicy.addAll(seeds);
        } else {
            log4j.warn((Object)"No seed order policy is used.");
        }
    }
}

