/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.LinkedList;
import java.util.List;
import org.aksw.coyotecache.cache.AbstractCache;

public class SLru
extends AbstractCache {
    protected final List<Object> m_access = new LinkedList<Object>();
    protected final List<Object> m_accessSeg = new LinkedList<Object>();
    private final float SEGMENT_BORDER = 0.5f;
    private final int SEGMENT_SIZE = (int)((float)this.m_cacheMaxSize * 0.5f);

    public SLru(int size, int evictCount) {
        super(size, evictCount);
    }

    @Override
    protected void evict() {
        for (int i = 0; i < this.m_evictCount; ++i) {
            Object o;
            if (!this.m_access.isEmpty()) {
                o = this.m_access.remove(0);
                this.m_cacheMap.remove(o);
                continue;
            }
            if (this.m_accessSeg.isEmpty()) continue;
            o = this.m_accessSeg.remove(0);
            this.m_cacheMap.remove(this.m_accessSeg.remove(0));
        }
    }

    @Override
    protected void hitAccess(Object key) {
        if (!this.m_access.remove(key)) {
            this.m_accessSeg.remove(key);
        }
        this.m_accessSeg.add(key);
        if (this.m_accessSeg.size() > this.SEGMENT_SIZE) {
            this.m_access.add(this.m_accessSeg.remove(0));
        }
    }

    @Override
    protected void putAccess(Object key) {
        this.m_access.add(key);
    }

    @Override
    public List<Object> removeValues(Object value) {
        List<Object> removed = super.removeValues(value);
        this.m_access.removeAll(removed);
        this.m_accessSeg.removeAll(removed);
        return removed;
    }

    @Override
    public boolean test() {
        return this.size() <= this.m_cacheMaxSize && this.m_access.size() + this.m_accessSeg.size() <= this.m_cacheMaxSize;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + this.m_access.toString();
    }
}

