/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import objectexplorer.MemoryMeasurer;
import org.aksw.coyotecache.cache.AbstractGD;
import org.aksw.coyotecache.cache.Element;

public class SGDStar
extends AbstractGD {
    public Double m_beta = 1.0;
    protected final List<Object> m_accessSeg = new LinkedList<Object>();
    private final float SEGMENT_BORDER = 0.5f;
    private final int SEGMENT_SIZE = (int)((float)this.m_cacheMaxSize * 0.5f);

    public SGDStar(int size, int evictCount) {
        super(size, evictCount);
    }

    @Override
    protected void hitAccess(Object key) {
        if (this.m_accessMap.remove(key) == null) {
            this.m_accessSeg.remove(key);
        }
        this.m_accessSeg.add(key);
        if (this.m_accessSeg.size() > this.SEGMENT_SIZE) {
            Object o = this.m_accessSeg.remove(0);
            Long mem = MemoryMeasurer.measureBytes((Object)((Element)o).getObject());
            this.m_accessMap.put(o, new GDStarElement(this.m_cacheAge, ((Element)o).getCost(), mem.doubleValue()));
        }
    }

    @Override
    protected void evict() {
        if (this.m_evictCount < this.m_accessMap.values().size()) {
            List<Object> evictElements = new LinkedList(this.m_accessMap.values());
            Collections.sort(evictElements);
            evictElements = evictElements.subList(0, this.m_evictCount);
            this.m_cacheAge = ((AbstractGD.GDElement)evictElements.get(0)).getCredit();
            Iterator accessIter = this.m_accessMap.entrySet().iterator();
            while (accessIter.hasNext() && !evictElements.isEmpty()) {
                Map.Entry entry = accessIter.next();
                if (!evictElements.contains(entry.getValue())) continue;
                evictElements.remove(entry.getValue());
                this.m_cacheMap.remove(entry.getKey());
                accessIter.remove();
            }
        } else {
            this.m_cacheMap.clear();
            this.m_accessMap.clear();
        }
    }

    @Override
    protected void putAccess(Object key) {
        Long mem = MemoryMeasurer.measureBytes((Object)((Element)key).getObject());
        GDStarElement element = new GDStarElement(this.m_cacheAge, ((Element)key).getCost(), mem.doubleValue());
        this.m_accessMap.put(key, element);
    }

    @Override
    public List<Object> removeValues(Object value) {
        List<Object> removed = super.removeValues(value);
        for (Object o : removed) {
            this.m_accessMap.remove(o);
        }
        return removed;
    }

    @Override
    public boolean test() {
        return this.size() <= this.m_cacheMaxSize && this.m_accessMap.size() <= this.m_cacheMaxSize && this.m_accessMap.size() <= this.size();
    }

    protected class GDStarElement
    extends AbstractGD.GDElement {
        private Integer m_hits = 0;
        private Double m_size = 0.0;
        private Double m_cost = 0.0;

        public GDStarElement(Double age, Double cost, Double size) {
            this.init(age, cost, size, 0);
        }

        public GDStarElement(Double age, Double cost, Double size, int hits) {
            this.init(age, cost, size, hits);
        }

        private void init(Double age, Double cost, Double size, int hits) {
            this.m_size = 1.0;
            this.m_cost = Math.abs(cost);
            this.update(this.m_cost);
        }

        @Override
        public void update(Double cost) {
            this.m_cost = this.m_cost + Math.abs(cost);
            this.m_cost = this.m_cost / 2.0;
            Integer n = this.m_hits;
            Integer n2 = this.m_hits = Integer.valueOf(this.m_hits + 1);
            super.update(Math.pow(cost * (double)this.m_hits.intValue() / this.m_size, 1.0 / SGDStar.this.m_beta));
        }
    }
}

