/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aksw.coyotecache.cache.AbstractCache;

public class Lru
extends AbstractCache {
    protected final List<Object> m_access = new LinkedList<Object>();

    public Lru(int size, int evictCount) {
        super(size, evictCount);
    }

    @Override
    protected void evict() {
        Iterator<Object> it = this.m_access.iterator();
        for (int i = 0; i < this.m_evictCount; ++i) {
            if (!it.hasNext()) continue;
            Object o = it.next();
            this.m_cacheMap.remove(o);
            it.remove();
        }
    }

    @Override
    protected void hitAccess(Object key) {
        int index = this.m_access.indexOf(key);
        if (index >= 0) {
            this.m_access.remove(index);
        } else {
            log4j.error((Object)"Was it realy a hit?");
        }
        this.m_access.add(key);
    }

    @Override
    protected void putAccess(Object key) {
        int index = this.m_access.indexOf(key);
        if (index >= 0) {
            log4j.error((Object)"Key in cache!");
            this.m_access.remove(index);
        }
        this.m_access.add(key);
    }

    @Override
    public List<Object> removeValues(Object value) {
        List<Object> removed = super.removeValues(value);
        this.m_access.removeAll(removed);
        return removed;
    }

    @Override
    public int size() {
        return this.m_cacheMap.size();
    }

    @Override
    public boolean test() {
        return this.size() <= this.m_cacheMaxSize && this.m_access.size() <= this.size() && this.m_access.size() <= this.m_cacheMaxSize;
    }

    @Override
    public String toString() {
        return this.m_cacheMap.toString() + "\n" + this.m_access.toString();
    }
}

