/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aksw.coyotecache.cache.AbstractGD;

public class LfuDA
extends AbstractGD {
    public LfuDA(int size, int evictCount) {
        super(size, evictCount);
    }

    @Override
    protected void hitAccess(Object key) {
        ((LFU_DA_Element)this.m_accessMap.get(key)).update();
    }

    @Override
    protected void evict() {
        if (this.m_evictCount < this.m_accessMap.values().size()) {
            List<Object> evictElements = new LinkedList(this.m_accessMap.values());
            Collections.sort(evictElements);
            evictElements = evictElements.subList(0, this.m_evictCount);
            this.m_cacheAge = ((AbstractGD.GDElement)evictElements.get(0)).getCredit();
            Iterator accessIter = this.m_accessMap.entrySet().iterator();
            while (accessIter.hasNext() && !evictElements.isEmpty()) {
                Map.Entry entry = accessIter.next();
                if (!evictElements.contains(entry.getValue())) continue;
                evictElements.remove(entry.getValue());
                this.m_cacheMap.remove(entry.getKey());
                accessIter.remove();
            }
        } else {
            this.m_cacheMap.clear();
            this.m_accessMap.clear();
        }
    }

    @Override
    public List<Object> removeValues(Object value) {
        List<Object> removed = super.removeValues(value);
        for (Object o : removed) {
            this.m_accessMap.remove(o);
        }
        return removed;
    }

    @Override
    public boolean test() {
        return this.size() <= this.m_cacheMaxSize && this.m_accessMap.size() <= this.m_cacheMaxSize && this.m_accessMap.size() <= this.size();
    }

    @Override
    protected void putAccess(Object key) {
        this.m_accessMap.put(key, new LFU_DA_Element());
    }

    protected class LFU_DA_Element
    extends AbstractGD.GDElement {
        private Integer m_hits = 0;

        public LFU_DA_Element() {
            this.update();
        }

        public void update() {
            Integer n = this.m_hits;
            Integer n2 = this.m_hits = Integer.valueOf(this.m_hits + 1);
            this.update((double)this.m_hits);
        }
    }
}

