/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aksw.coyotecache.cache.AbstractCache;

public class Lfu
extends AbstractCache {
    protected final Map<Object, Integer> m_access = new LinkedHashMap<Object, Integer>();

    public Lfu(int size, int evictCount) {
        super(size, evictCount);
    }

    @Override
    protected void evict() {
        if (this.m_evictCount < this.m_access.size()) {
            List<Integer> minHits = new ArrayList<Integer>(this.m_access.values());
            Collections.sort(minHits);
            minHits = minHits.subList(0, this.m_evictCount);
            Iterator<Map.Entry<Object, Integer>> accessIter = this.m_access.entrySet().iterator();
            while (accessIter.hasNext() && !minHits.isEmpty()) {
                Map.Entry<Object, Integer> entry = accessIter.next();
                if (!minHits.contains(entry.getValue())) continue;
                minHits.remove(entry.getValue());
                accessIter.remove();
                this.m_cacheMap.remove(entry.getKey());
            }
        } else {
            this.m_access.clear();
            this.m_cacheMap.clear();
        }
    }

    @Override
    protected void hitAccess(Object key) {
        Integer id = this.m_access.get(key);
        if (id != null) {
            id = id + 1;
            this.m_access.put(key, id);
        } else {
            this.m_access.put(key, 0);
            log4j.error((Object)"Can't find key. Was it realy a hit?");
        }
    }

    @Override
    protected void putAccess(Object key) {
        Integer id = this.m_access.get(key);
        if (id != null) {
            id = id + 1;
            this.m_access.put(key, id);
        } else {
            this.m_access.put(key, 0);
        }
    }

    @Override
    public List<Object> removeValues(Object value) {
        List<Object> removed = super.removeValues(value);
        for (Object o : removed) {
            this.m_access.remove(o);
        }
        return removed;
    }

    @Override
    public boolean test() {
        return this.size() <= this.m_cacheMaxSize && this.m_access.size() <= this.size() && this.m_access.size() <= this.m_cacheMaxSize;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + this.m_access.toString();
    }
}

