/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import objectexplorer.MemoryMeasurer;
import org.aksw.coyotecache.cache.AbstractGD;
import org.aksw.coyotecache.cache.Element;

public class GDStar
extends AbstractGD {
    public Double m_beta = 1.0;

    public GDStar(int size, int evictCount) {
        super(size, evictCount);
    }

    @Override
    protected void hitAccess(Object key) {
        ((GDStarElement)this.m_accessMap.get(key)).update(((Element)key).getCost());
    }

    @Override
    protected void evict() {
        if (this.m_evictCount < this.m_accessMap.values().size()) {
            List<Object> evictElements = new LinkedList(this.m_accessMap.values());
            Collections.sort(evictElements);
            evictElements = evictElements.subList(0, this.m_evictCount);
            this.m_cacheAge = ((AbstractGD.GDElement)evictElements.get(0)).getCredit();
            Iterator accessIter = this.m_accessMap.entrySet().iterator();
            while (accessIter.hasNext() && !evictElements.isEmpty()) {
                Map.Entry entry = accessIter.next();
                if (!evictElements.contains(entry.getValue())) continue;
                evictElements.remove(entry.getValue());
                this.m_cacheMap.remove(entry.getKey());
                accessIter.remove();
            }
        } else {
            this.m_cacheMap.clear();
            this.m_accessMap.clear();
        }
    }

    @Override
    public List<Object> removeValues(Object value) {
        List<Object> removed = super.removeValues(value);
        for (Object o : removed) {
            this.m_accessMap.remove(o);
        }
        return removed;
    }

    @Override
    public boolean test() {
        return this.size() <= this.m_cacheMaxSize && this.m_accessMap.size() <= this.m_cacheMaxSize && this.m_accessMap.size() <= this.size();
    }

    @Override
    protected void putAccess(Object key) {
        Long mem = MemoryMeasurer.measureBytes((Object)((Element)key).getObject());
        this.m_accessMap.put(key, new GDStarElement(this.m_cacheAge, ((Element)key).getCost(), mem.doubleValue()));
    }

    protected class GDStarElement
    extends AbstractGD.GDElement {
        private Integer m_hits = 0;
        private Double m_size = 0.0;
        private Double m_cost = 0.0;

        public GDStarElement(Double age, Double cost, Double size) {
            this.m_size = size;
            this.m_cost = cost;
            this.update(cost);
        }

        @Override
        public void update(Double cost) {
            this.m_cost = this.m_cost + cost;
            this.m_cost = this.m_cost / 2.0;
            Integer n = this.m_hits;
            Integer n2 = this.m_hits = Integer.valueOf(this.m_hits + 1);
            super.update(Math.pow(cost * (double)this.m_hits.intValue() / this.m_size, 1.0 / GDStar.this.m_beta));
        }
    }
}

