/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.aksw.coyotecache.cache.AbstractCache;
import org.aksw.coyotecache.cache.Fifo2ndChanceElement;

public class Fifo2ndChance
extends AbstractCache {
    protected final Queue<Fifo2ndChanceElement> m_access = new LinkedList<Fifo2ndChanceElement>();

    public Fifo2ndChance(int size, int evictCount) {
        super(size, evictCount);
    }

    @Override
    protected void evict() {
        int i = 0;
        while (i < this.m_evictCount) {
            Fifo2ndChanceElement fifo = this.m_access.poll();
            if (fifo.m_state == Fifo2ndChanceElement.State.HIT) {
                fifo.m_state = Fifo2ndChanceElement.State.SECOND;
                this.m_access.add(fifo);
                continue;
            }
            ++i;
            this.m_cacheMap.remove(fifo.m_o);
        }
    }

    @Override
    protected void hitAccess(Object key) {
        Iterator iter = this.m_access.iterator();
        boolean found = false;
        while (iter.hasNext()) {
            Fifo2ndChanceElement fifo2ndChanceElement = (Fifo2ndChanceElement)iter.next();
            if (!fifo2ndChanceElement.equals(new Fifo2ndChanceElement(key))) continue;
            found = true;
            if (fifo2ndChanceElement.m_state != Fifo2ndChanceElement.State.NONE) break;
            fifo2ndChanceElement.m_state = Fifo2ndChanceElement.State.HIT;
            break;
        }
        if (log4j.isDebugEnabled() && !found) {
            log4j.debug((Object)"hit Access cant find key. realy a hit?");
        }
    }

    @Override
    protected void putAccess(Object key) {
        boolean found;
        if (log4j.isDebugEnabled() && (found = this.m_access.contains(new Fifo2ndChanceElement(key)))) {
            this.m_access.remove(found);
            log4j.debug((Object)"putAccess find key. key in cache!");
        }
        this.m_access.add(new Fifo2ndChanceElement(key));
    }

    @Override
    public List<Object> removeValues(Object value) {
        List<Object> removed = super.removeValues(value);
        for (Object o : removed) {
            this.m_access.remove(new Fifo2ndChanceElement(o));
        }
        return removed;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + this.m_access.toString();
    }
}

