/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.aksw.coyotecache.cache.AbstractCache;

public class Fifo
extends AbstractCache {
    protected Queue<Object> m_access = new LinkedList<Object>();

    public Fifo(int size, int evictCount) {
        super(size, evictCount);
    }

    @Override
    protected void evict() {
        for (int i = 0; i < this.m_evictCount && !this.m_access.isEmpty(); ++i) {
            Object o = this.m_access.poll();
            this.m_cacheMap.remove(o);
        }
    }

    @Override
    protected void hitAccess(Object key) {
    }

    @Override
    protected void putAccess(Object key) {
        this.m_access.add(key);
    }

    @Override
    public List<Object> removeValues(Object value) {
        List<Object> remove = super.removeValues(value);
        this.m_access.removeAll(remove);
        return remove;
    }

    @Override
    public boolean test() {
        return this.size() <= this.m_cacheMaxSize && this.m_access.size() <= this.size() && this.m_access.size() <= this.m_cacheMaxSize;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + this.m_access.toString();
    }
}

