/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aksw.coyotecache.cache.AbstractCache;
import org.aksw.coyotecache.cache.Element;

public class Cost
extends AbstractCache {
    protected final Map<Object, Double> m_access = new LinkedHashMap<Object, Double>();

    public Cost(int size, int evictCount) {
        super(size, evictCount);
    }

    @Override
    protected void evict() {
        List<Double> costs = new LinkedList<Double>(this.m_access.values());
        Collections.sort(costs, Collections.reverseOrder());
        costs = costs.subList(0, this.m_evictCount);
        Iterator<Map.Entry<Object, Double>> accessIter = this.m_access.entrySet().iterator();
        while (accessIter.hasNext() && !costs.isEmpty()) {
            Map.Entry<Object, Double> entry = accessIter.next();
            if (!costs.contains(entry.getValue())) continue;
            costs.remove(entry.getValue());
            this.m_access.remove(entry.getKey());
            this.m_cacheMap.remove(entry.getKey());
        }
    }

    @Override
    protected void hitAccess(Object key) {
        this.putAccess(key);
    }

    @Override
    protected void putAccess(Object key) {
        Double cost = this.m_access.get(key);
        if (key instanceof Element) {
            if (cost == null || cost > ((Element)key).getCost()) {
                cost = ((Element)key).getCost();
            }
            this.m_access.put(key, cost);
        } else {
            log4j.warn((Object)"You have to use instances of Element for the cache key. Otherwiese the cache uses Fifo behavior.");
            if (cost == null) {
                this.m_access.put(key, 1.0);
            }
        }
    }

    @Override
    public List<Object> removeValues(Object value) {
        List<Object> removed = super.removeValues(value);
        for (Object o : removed) {
            this.m_access.remove(o);
        }
        return removed;
    }
}

