/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.coyotecache.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aksw.coyotecache.cache.CacheInterface;
import org.apache.log4j.Logger;

public abstract class AbstractCache
implements CacheInterface {
    public static Logger log4j = Logger.getLogger(AbstractCache.class);
    protected Map<Object, Object> m_cacheMap = new HashMap<Object, Object>();
    protected final int m_cacheMaxSize;
    protected final int m_evictCount;

    public AbstractCache(int size, int evictCount) {
        this.m_cacheMaxSize = size;
        this.m_evictCount = evictCount;
    }

    @Override
    public Collection<Object> values() {
        return this.m_cacheMap.values();
    }

    @Override
    public Object get(Object key) {
        Object value = this.m_cacheMap.get(key);
        if (value != null) {
            this.hitAccess(key);
        }
        if (log4j.isDebugEnabled()) {
            if (value != null) {
                log4j.debug((Object)("hit:" + key.toString()));
            } else {
                log4j.debug((Object)("miss: " + key.toString()));
            }
        }
        return value;
    }

    protected abstract void hitAccess(Object var1);

    @Override
    public int maxSize() {
        return this.m_cacheMaxSize;
    }

    @Override
    public Object put(Object key, Object val) {
        if (this.m_cacheMaxSize > 0) {
            if (this.size() >= this.m_cacheMaxSize) {
                this.evict();
            }
            this.putAccess(key);
            if (log4j.isDebugEnabled()) {
                log4j.debug((Object)("put:" + key.toString()));
            }
            return this.m_cacheMap.put(key, val);
        }
        return null;
    }

    protected abstract void evict();

    protected abstract void putAccess(Object var1);

    @Override
    public List<Object> removeValues(Object value) {
        ArrayList<Object> removed = new ArrayList<Object>();
        Iterator<Object> iter = this.m_cacheMap.keySet().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (this.m_cacheMap.get(o) != value) continue;
            removed.add(o);
            iter.remove();
        }
        return removed;
    }

    @Override
    public int size() {
        return this.m_cacheMap.size();
    }

    @Override
    public boolean test() {
        return false;
    }

    public String toString() {
        return this.m_cacheMap.toString();
    }
}

