/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.jdbc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.aksw.commons.util.jdbc.ForeignKey;
import org.aksw.commons.util.jdbc.Index;
import org.aksw.commons.util.jdbc.JdbcUtils;
import org.aksw.commons.util.jdbc.PrimaryKey;
import org.aksw.commons.util.jdbc.Relation;

public class Schema {
    private Map<String, Relation> relations;
    private Map<String, PrimaryKey> primaryKeys;
    private Multimap<String, ForeignKey> foreignKeys;
    private Multimap<String, Index> indexes;

    public Schema(Map<String, Relation> relations, Map<String, PrimaryKey> primaryKeys, Multimap<String, ForeignKey> foreignKeys, Multimap<String, Index> indexes) {
        this.relations = relations;
        this.primaryKeys = primaryKeys;
        this.foreignKeys = foreignKeys;
        this.indexes = indexes;
    }

    public Map<String, Relation> getRelations() {
        return this.relations;
    }

    public Map<String, PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public Multimap<String, ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public Multimap<String, Index> getIndexes() {
        return this.indexes;
    }

    public static Schema create(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Schema result = Schema.create(meta, catalog);
        return result;
    }

    public static Schema create(DatabaseMetaData meta, String catalog) throws SQLException {
        Map<String, Relation> relations = JdbcUtils.fetchColumns(meta, catalog);
        Map<String, PrimaryKey> primaryKeys = JdbcUtils.fetchPrimaryKeys(meta, catalog);
        Multimap<String, ForeignKey> foreignKeys = JdbcUtils.fetchForeignKeys(meta, catalog);
        HashMultimap indexes = HashMultimap.create();
        for (String tableName : relations.keySet()) {
            Multimap<String, Index> tmp = JdbcUtils.fetchIndexes(meta, catalog, null, tableName, true);
            indexes.putAll(tmp);
        }
        Schema result = new Schema(relations, primaryKeys, foreignKeys, (Multimap<String, Index>)indexes);
        return result;
    }
}

