/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerializationUtils {
    public static void serializeXml(Object obj, File file) throws IOException {
        SerializationUtils.serializeXml(obj, file, false);
    }

    public static void serializeXml(Object obj, File file, boolean force) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(file);
        SerializationUtils.serializeXml(obj, out);
        out.flush();
        ((OutputStream)out).close();
    }

    public static void serializeXml(Object obj, OutputStream out) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.toXML(obj, out);
    }

    public static Object deserializeXml(InputStream in) throws IOException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        Object result = xstream.fromXML(in);
        return result;
    }

    public static Object deserializeXml(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        Object result = SerializationUtils.deserializeXml(in);
        ((InputStream)in).close();
        return result;
    }
}

