/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.reflect;

import java.lang.reflect.Method;
import org.aksw.commons.util.reflect.MultiMethod;

public class Caster {
    public static Object tryCast(Object value, Class<?> targetClass) {
        try {
            Method method = MultiMethod.findInvocationMethod(Caster.class, targetClass, value.getClass());
            return method.invoke(null, value);
        }
        catch (Exception e) {
            if (e.getCause() instanceof NumberFormatException) {
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        System.out.println(Caster.tryCast("123.4", Double.class));
        System.out.println(Caster.tryCast(123.4, String.class));
        System.out.println(Caster.tryCast("test", Double.class));
    }

    public static String toString(Object o) {
        return o.toString();
    }

    public static Boolean toBoolean(String a) {
        return Boolean.parseBoolean(a);
    }

    public static Integer toInteger(Long a) {
        return a.intValue();
    }

    public static Integer toInteger(Float a) {
        return a.intValue();
    }

    public static Integer toInteger(Double a) {
        return a.intValue();
    }

    public static Integer toInteger(String a) {
        return Integer.parseInt(a);
    }

    public static Long toLong(Integer a) {
        return a.longValue();
    }

    public static Long toLong(Float a) {
        return a.longValue();
    }

    public static Long toLong(Double a) {
        return a.longValue();
    }

    public static Long toLong(String a) {
        return Long.parseLong(a);
    }

    public static Float toFloat(Long a) {
        return Float.valueOf(a.floatValue());
    }

    public static Float toFloat(Integer a) {
        return Float.valueOf(a.floatValue());
    }

    public static Float toFloat(Double a) {
        return Float.valueOf(a.floatValue());
    }

    public static Float toFloat(String s) {
        return Float.valueOf(Float.parseFloat(s));
    }

    public static Double toDouble(Integer a) {
        return a.doubleValue();
    }

    public static Double toDouble(Long a) {
        return a.doubleValue();
    }

    public static Double toDouble(Float a) {
        return a.doubleValue();
    }

    public static Double toDouble(String a) {
        return Double.parseDouble(a);
    }
}

