/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.jdbc;

import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.aksw.commons.util.jdbc.ForeignKey;
import org.aksw.commons.util.jdbc.JdbcUtils;
import org.aksw.commons.util.jdbc.PrimaryKey;
import org.aksw.commons.util.jdbc.Relation;

public class Schema {
    private Map<String, Relation> relations;
    private Map<String, PrimaryKey> primaryKeys;
    private Multimap<String, ForeignKey> foreignKeys;

    public Schema(Map<String, Relation> relations, Map<String, PrimaryKey> primaryKeys, Multimap<String, ForeignKey> foreignKeys) {
        this.relations = relations;
        this.primaryKeys = primaryKeys;
        this.foreignKeys = foreignKeys;
    }

    public Map<String, Relation> getRelations() {
        return this.relations;
    }

    public Map<String, PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public Multimap<String, ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public static Schema create(Connection conn) throws SQLException {
        Map<String, Relation> relations = JdbcUtils.fetchColumns(conn);
        Map<String, PrimaryKey> primaryKeys = JdbcUtils.fetchPrimaryKeys(conn, relations.keySet());
        Multimap<String, ForeignKey> foreignKeys = JdbcUtils.fetchForeignKeys(conn, relations.keySet());
        Schema result = new Schema(relations, primaryKeys, foreignKeys);
        return result;
    }
}

