/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.jdbc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.commons.util.jdbc.Column;
import org.aksw.commons.util.jdbc.ColumnsReference;
import org.aksw.commons.util.jdbc.DatabaseObject;
import org.aksw.commons.util.jdbc.ForeignKey;
import org.aksw.commons.util.jdbc.PrimaryKey;
import org.aksw.commons.util.jdbc.Relation;

public class JdbcUtils {
    public static Multimap<String, ForeignKey> fetchForeignKeys(Connection conn) throws SQLException {
        Set<String> tableNames = JdbcUtils.fetchRelationNames(conn);
        Multimap<String, ForeignKey> result = JdbcUtils.fetchForeignKeys(conn, tableNames);
        return result;
    }

    public static Multimap<String, ForeignKey> fetchForeignKeys(Connection conn, Collection<String> tableNames) throws SQLException {
        HashMultimap result = HashMultimap.create();
        for (String tableName : tableNames) {
            Multimap<String, ForeignKey> part = JdbcUtils.fetchForeignKeys(conn, tableName);
            result.putAll(part);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Multimap<String, ForeignKey> fetchForeignKeys(Connection conn, String tableName) throws SQLException {
        HashMultimap result = HashMultimap.create();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getExportedKeys(conn.getCatalog(), null, tableName);
        try {
            HashMap<String, ForeignKey> fkNameMap = new HashMap<String, ForeignKey>();
            while (rs.next()) {
                String fkName = rs.getString("FK_NAME");
                String fkTableName = rs.getString("FKTABLE_NAME");
                String fkColumnName = rs.getString("FKCOLUMN_NAME");
                String pkTableName = rs.getString("PKTABLE_NAME");
                String pkColumnName = rs.getString("PKCOLUMN_NAME");
                ForeignKey current = (ForeignKey)fkNameMap.get(fkName);
                if (current == null) {
                    current = new ForeignKey(fkName, new ColumnsReference(fkTableName, new String[0]), new ColumnsReference(pkTableName, new String[0]));
                    fkNameMap.put(fkName, current);
                }
                current.getSource().getColumnNames().add(fkColumnName);
                current.getTarget().getColumnNames().add(pkColumnName);
            }
            for (ForeignKey fk : fkNameMap.values()) {
                result.put((Object)fk.getSource().getTableName(), (Object)fk);
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    public static Map<String, PrimaryKey> fetchPrimaryKeys(Connection conn) throws SQLException {
        Set<String> tableNames = JdbcUtils.fetchRelationNames(conn);
        Map<String, PrimaryKey> result = JdbcUtils.fetchPrimaryKeys(conn, tableNames);
        return result;
    }

    public static Map<String, PrimaryKey> fetchPrimaryKeys(Connection conn, Collection<String> tableNames) throws SQLException {
        HashMap<String, PrimaryKey> result = new HashMap<String, PrimaryKey>();
        for (String tableName : tableNames) {
            Map<String, PrimaryKey> part = JdbcUtils.fetchPrimaryKeys(conn, tableName);
            result.putAll(part);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, PrimaryKey> fetchPrimaryKeys(Connection conn, String tableName) throws SQLException {
        HashMap<String, PrimaryKey> result = new HashMap<String, PrimaryKey>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getPrimaryKeys(conn.getCatalog(), null, tableName);
        try {
            PrimaryKey current = null;
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String pkName = rs.getString("PK_NAME");
                if (current == null || !tableName.equals(current.getSource().getTableName())) {
                    current = new PrimaryKey(pkName, new ColumnsReference(tableName, new String[0]));
                    result.put(tableName, current);
                }
                current.getSource().getColumnNames().add(columnName);
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> fetchRelationNames(Connection conn) throws SQLException {
        String[] types = new String[]{"TABLE", "VIEW"};
        ResultSet rs = conn.getMetaData().getTables(conn.getCatalog(), null, null, types);
        TreeSet<String> result = new TreeSet<String>();
        try {
            while (rs.next()) {
                result.add(rs.getString("TABLE_NAME"));
            }
        }
        finally {
            rs.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Relation> fetchColumns(Connection conn) throws SQLException {
        HashMap<String, Relation> result = new HashMap<String, Relation>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getColumns(conn.getCatalog(), null, null, null);
        try {
            DatabaseObject current = null;
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                String typeName = rs.getString("TYPE_NAME");
                String rawIsNullable = rs.getString("IS_NULLABLE");
                Boolean isNullable = null;
                if ("YES".equalsIgnoreCase(rawIsNullable)) {
                    isNullable = true;
                } else if ("NO".equalsIgnoreCase(rawIsNullable)) {
                    isNullable = false;
                }
                if (current == null || !tableName.equals(current.getName())) {
                    current = new Relation(tableName);
                    result.put(tableName, (Relation)current);
                }
                Column column = new Column(columnName, typeName, isNullable);
                ((Relation)current).getColumns().put(columnName, column);
            }
        }
        finally {
            rs.close();
        }
        return result;
    }
}

