/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static String toString(Node node) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XmlUtils.toText(node, baos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return baos.toString();
    }

    public static Document createFromString(String text) throws Exception {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(text)));
    }

    public static void toText(Node node, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(node);
        StreamResult output = new StreamResult(out);
        transformer.transform(source, output);
    }

    public static Document openFile(File file) throws Exception {
        FileInputStream inputStream = new FileInputStream(file);
        Document result = XmlUtils.loadFromStream(inputStream);
        ((InputStream)inputStream).close();
        return result;
    }

    public static Document openUrl(String location) throws Exception {
        URL url = new URL(location);
        URLConnection con = url.openConnection();
        InputStream responseStream = con.getInputStream();
        Document result = XmlUtils.loadFromStream(responseStream);
        responseStream.close();
        return result;
    }

    public static Document loadFromStream(InputStream inputStream) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        Document doc = builder.parse(inputStream);
        return doc;
    }

    public static String getPageModificationDate(Document node) {
        String strModificationDate = null;
        try {
            strModificationDate = node.getElementsByTagName("datestamp").item(0).getTextContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return strModificationDate;
    }
}

