/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtils {
    private static Logger logger = LoggerFactory.getLogger(XPathUtils.class);
    private static XPath xPath = null;

    private static XPath getXPath() {
        if (xPath == null) {
            xPath = XPathFactory.newInstance().newXPath();
        }
        return xPath;
    }

    public static XPathExpression compile(String expression) throws Exception {
        try {
            return XPathUtils.getXPath().compile(expression);
        }
        catch (Exception e) {
            logger.error("Error compiling XPath", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String evalToString(Node node, XPathExpression expr) {
        try {
            return expr.evaluate(node);
        }
        catch (Exception e) {
            logger.error("Error evaluating XPath expression", (Throwable)e);
            return null;
        }
    }

    public static String evalToString(Node node, String query) throws XPathExpressionException {
        return (String)XPathUtils.getXPath().evaluate(query, node, XPathConstants.STRING);
    }

    public static String evalToString(Node node, String query, boolean dummy) {
        try {
            return XPathUtils.evalToString(node, query);
        }
        catch (Exception e) {
            logger.error("Error evaluating XPath expression", (Throwable)e);
            return null;
        }
    }

    public static NodeList evalToNodes(Node node, String query) {
        try {
            return (NodeList)XPathUtils.getXPath().evaluate(query, node, XPathConstants.NODESET);
        }
        catch (Exception e) {
            logger.error("Error evaluating XPath expression", (Throwable)e);
            return null;
        }
    }
}

