/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.strings;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeSet;

public class StringUtils {
    public static String strip(String str, String ... chars) {
        for (String c : chars) {
            if (str.length() < 2) {
                return str;
            }
            if (!str.startsWith(c) || !str.endsWith(c)) continue;
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static <T> T coalesce(T ... args) {
        for (T arg : args) {
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    public static String ucFirst(String str) {
        return str.isEmpty() ? "" : str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String lcFirst(String str) {
        return str.isEmpty() ? "" : str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String toLowerCamelCase(String s) {
        return StringUtils.toCamelCase(s, false);
    }

    public static String toUpperCamelCase(String s) {
        return StringUtils.toCamelCase(s, true);
    }

    public static String toCamelCase(String s, boolean upper) {
        String result = "";
        for (String part : s.split("_")) {
            result = result + StringUtils.ucFirst(part);
        }
        result = upper ? result : StringUtils.lcFirst(result);
        return result;
    }

    public static String cropString(String str, int nMax, int nTolerance) {
        int tooMany;
        String result = str;
        int nGiven = str.length();
        if (nGiven > nMax && (tooMany = nGiven - nMax) > nTolerance) {
            result = str.substring(0, nMax) + "... (" + tooMany + " more bytes)";
        }
        return result;
    }

    public static String commonPrefix(String sa, String sb, boolean skipLast) {
        int i;
        char[] a = sa.toCharArray();
        char[] b = sb.toCharArray();
        int n = Math.min(a.length, b.length);
        char[] tmp = new char[n];
        for (i = 0; i < n; ++i) {
            if (a[i] != b[i]) {
                tmp[i] = '\u0000';
                break;
            }
            tmp[i] = a[i];
        }
        if (skipLast) {
            if (i == 0) {
                return null;
            }
            tmp[i - 1] = '\u0000';
        }
        return new String(tmp);
    }

    public static <T> String longestPrefixLookup(String lookup, NavigableSet<String> prefixes) {
        return StringUtils.longestPrefixLookup(lookup, true, prefixes);
    }

    public static <T> String longestPrefixLookup(String lookup, boolean inclusive, NavigableSet<String> prefixes) {
        String current = lookup;
        NavigableSet<String> candidates;
        while (!(candidates = prefixes.headSet(current, true).descendingSet()).isEmpty()) {
            String candidate = (String)candidates.first();
            if (candidate == null) {
                return null;
            }
            if (current.equals(candidate)) {
                if (inclusive) {
                    return candidate;
                }
                if (current.equals(lookup)) {
                    if ((current = StringUtils.commonPrefix(current, candidate, true)) != null) continue;
                    return null;
                }
                return candidate;
            }
            current = StringUtils.commonPrefix(current, candidate, false);
        }
        return null;
    }

    public static <T> Map.Entry<String, T> longestPrefixLookup(String lookup, NavigableMap<String, T> prefixMap) {
        return StringUtils.longestPrefixLookup(lookup, true, prefixMap);
    }

    public static <T> Map<String, T> getAllPrefixes(String lookup, boolean inclusive, NavigableMap<String, T> prefixMap) {
        HashMap<String, T> result = new HashMap<String, T>();
        Map.Entry<String, T> entry = StringUtils.longestPrefixLookup(lookup, inclusive, prefixMap);
        if (entry != null) {
            result.put(entry.getKey(), entry.getValue());
            String current = entry.getKey();
            while ((entry = StringUtils.longestPrefixLookup(entry.getKey(), false, prefixMap)) != null) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static <T> NavigableSet<String> getAllPrefixes(String lookup, boolean inclusive, NavigableSet<String> prefixMap) {
        TreeSet<String> result = new TreeSet<String>();
        String entry = StringUtils.longestPrefixLookup(lookup, inclusive, prefixMap);
        if (entry != null) {
            result.add(entry);
            while ((entry = StringUtils.longestPrefixLookup(entry, false, prefixMap)) != null) {
                result.add(entry);
            }
        }
        return result;
    }

    public static <T> Map<String, T> getAllPrefixes(String lookup, boolean inclusive, SortedMap<String, T> prefixMap) {
        HashMap<String, T> result = new HashMap<String, T>();
        Map.Entry<String, T> entry = StringUtils.longestPrefixLookup(lookup, inclusive, prefixMap);
        if (entry != null) {
            result.put(entry.getKey(), entry.getValue());
            String current = entry.getKey();
            while ((entry = StringUtils.longestPrefixLookup(entry.getKey(), false, prefixMap)) != null) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public static <T> Map<String, T> getAllPrefixedEntries(String prefix, boolean inclusive, SortedMap<String, T> prefixMap) {
        HashMap<String, T> result = new HashMap<String, T>();
        SortedMap<String, T> candidates = prefixMap.tailMap(prefix);
        boolean isFirst = true;
        for (Map.Entry<String, T> entry : candidates.entrySet()) {
            if (isFirst && !inclusive && entry.getKey().equals(prefix)) {
                isFirst = false;
                continue;
            }
            if (entry.getKey() == null || !entry.getKey().startsWith(prefix)) break;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> Map<String, T> getAllPrefixedEntries(String prefix, boolean inclusive, NavigableMap<String, T> prefixMap) {
        HashMap result = new HashMap();
        NavigableMap<String, T> candidates = prefixMap.tailMap(prefix, inclusive);
        for (Map.Entry entry : candidates.entrySet()) {
            if (entry.getKey() == null || !((String)entry.getKey()).startsWith(prefix)) break;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> Map.Entry<String, T> longestPrefixLookup(String lookup, boolean inclusive, NavigableMap<String, T> prefixMap) {
        String current = lookup;
        NavigableMap<String, T> candidates;
        Map.Entry<String, T> candidate;
        while ((candidate = (candidates = prefixMap.headMap(current, true).descendingMap()).firstEntry()) != null) {
            String key = candidate.getKey();
            if (current.equals(key)) {
                if (inclusive) {
                    return candidate;
                }
                if (current.equals(lookup)) {
                    if ((current = StringUtils.commonPrefix(current, key, true)) != null) continue;
                    return null;
                }
                return candidate;
            }
            current = StringUtils.commonPrefix(current, key, false);
        }
        return null;
    }

    public static <T> Map.Entry<String, T> longestPrefixLookup(String lookup, boolean inclusive, SortedMap<String, T> prefixMap) {
        String current = lookup;
        SortedMap<String, T> candidates;
        while (!(candidates = prefixMap.headMap(current)).isEmpty()) {
            Map.Entry<String, T> candidate = candidates.entrySet().iterator().next();
            String key = candidate.getKey();
            if (current.equals(key)) {
                if (inclusive) {
                    return candidate;
                }
                if (current.equals(lookup)) {
                    if ((current = StringUtils.commonPrefix(current, key, true)) != null) continue;
                    return null;
                }
                return candidate;
            }
            current = StringUtils.commonPrefix(current, key, false);
        }
        return null;
    }

    public static <V> Map.Entry<String, V> shortestMatchLookup(String prefix, boolean inclusive, NavigableMap<String, V> items) {
        NavigableMap<String, V> candidates = items.tailMap(prefix, inclusive).descendingMap();
        if (candidates.isEmpty()) {
            return null;
        }
        Map.Entry<String, V> candidate = candidates.lastEntry();
        return candidate.getKey().startsWith(prefix) ? candidate : null;
    }

    public static String shortestMatchLookup(String prefix, boolean inclusive, NavigableSet<String> items) {
        NavigableSet<String> candidates = items.tailSet(prefix, inclusive).descendingSet();
        if (candidates.isEmpty()) {
            return null;
        }
        String candidate = (String)candidates.last();
        return candidate.startsWith(prefix) ? candidate : null;
    }

    public static <T> Map.Entry<String, T> getMatchBySuffix(String str, Map<String, T> map) {
        Map.Entry<String, T> bestMatch = null;
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String key = entry.getKey();
            if (!str.endsWith(key)) continue;
            bestMatch = bestMatch == null ? entry : (key.length() > bestMatch.getKey().length() ? entry : bestMatch);
        }
        return bestMatch;
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String urlDecode(String str) {
        try {
            return URLDecoder.decode(str, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String md5Hash(byte[] bytes) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        md5.reset();
        md5.update(bytes);
        byte[] rawResult = md5.digest();
        return StringUtils.bytesToHexString(rawResult);
    }

    public static String bytesToHexString(byte[] bytes) {
        String result = "";
        for (int i = 0; i < bytes.length; ++i) {
            int value = 0xFF & bytes[i];
            if (value < 16) {
                result = result + "0";
            }
            result = result + Integer.toHexString(value);
        }
        return result;
    }

    public static String md5Hash(String string) {
        return StringUtils.md5Hash(string.getBytes());
    }
}

