/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.jdbc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.aksw.commons.util.jdbc.Column;
import org.aksw.commons.util.jdbc.ColumnsReference;
import org.aksw.commons.util.jdbc.DatabaseObject;
import org.aksw.commons.util.jdbc.ForeignKey;
import org.aksw.commons.util.jdbc.PrimaryKey;
import org.aksw.commons.util.jdbc.Relation;

public class JdbcUtils {
    public static Multimap<String, ForeignKey> fetchForeignKeys(Connection conn) throws SQLException {
        HashMultimap result = HashMultimap.create();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getExportedKeys(conn.getCatalog(), null, null);
        ForeignKey current = null;
        while (rs.next()) {
            String pkTableName = rs.getString("PKTABLE_NAME");
            String pkColumnName = rs.getString("PKCOLUMN_NAME");
            String fkName = rs.getString("FK_NAME");
            String fkTableName = rs.getString("FKTABLE_NAME");
            String fkColumnName = rs.getString("FKCOLUMN_NAME");
            if (current == null || !fkTableName.equals(current.getSource().getTableName())) {
                current = new ForeignKey(fkName, new ColumnsReference(fkTableName), new ColumnsReference(pkTableName));
                result.put((Object)fkTableName, (Object)current);
            }
            current.getSource().getColumnNames().add(pkColumnName);
            current.getTarget().getColumnNames().add(fkColumnName);
        }
        conn.close();
        return result;
    }

    public static Map<String, PrimaryKey> fetchPrimaryKeys(Connection conn) throws SQLException {
        HashMap<String, PrimaryKey> result = new HashMap<String, PrimaryKey>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getPrimaryKeys(conn.getCatalog(), null, null);
        PrimaryKey current = null;
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            String pkName = rs.getString("PK_NAME");
            if (current == null || !tableName.equals(current.getSource().getTableName())) {
                current = new PrimaryKey(pkName, new ColumnsReference(tableName));
                result.put(tableName, current);
            }
            current.getSource().getColumnNames().add(columnName);
        }
        conn.close();
        return result;
    }

    public static Set<String> fetchRelationNames(Connection conn) throws SQLException {
        String[] types = new String[]{"TABLE", "VIEW"};
        ResultSet rs = conn.getMetaData().getTables(conn.getCatalog(), null, null, types);
        TreeSet<String> result = new TreeSet<String>();
        while (rs.next()) {
            result.add(rs.getString("TABLE_NAME"));
        }
        return result;
    }

    public static Map<String, Relation> fetchColumns(Connection conn) throws SQLException {
        HashMap<String, Relation> result = new HashMap<String, Relation>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getColumns(conn.getCatalog(), null, null, null);
        DatabaseObject current = null;
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            String typeName = rs.getString("TYPE_NAME");
            if (current == null || !tableName.equals(current.getName())) {
                current = new Relation(tableName);
                result.put(tableName, (Relation)current);
            }
            Column column = new Column(columnName, typeName);
            ((Relation)current).getColumns().put(columnName, column);
        }
        conn.close();
        return result;
    }
}

